/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige.core;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.PrestigeTree;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public abstract class PrestigePower
extends LearnableSkill {
    protected int learnKnowledgeCost;
    protected int tier;
    protected int tierLock;

    public PrestigePower(int unlockLevel, int learnPointCost, int regretCost) {
        this(unlockLevel, learnPointCost, 0, regretCost, 0);
    }

    public PrestigePower(int unlockLevel, int learnPointCost, int learnKnowledgeCost, int regretCost) {
        this(unlockLevel, learnPointCost, learnKnowledgeCost, regretCost, 0);
    }

    public PrestigePower(int unlockLevel, int learnPointCost, int learnKnowledgeCost, int regretCost, int tierLock) {
        super(unlockLevel, learnPointCost, regretCost);
        this.learnKnowledgeCost = learnKnowledgeCost;
        this.tierLock = tierLock;
    }

    protected PrestigePower() {
        this.learnKnowledgeCost = 0;
        this.tierLock = 0;
    }

    public int getLearnKnowledgeCost() {
        return this.learnKnowledgeCost;
    }

    public int getTierLock() {
        return this.tierLock;
    }

    public int getSpentAdditionalLearnPoints() {
        return this.isUnlocked() ? this.learnKnowledgeCost : 0;
    }

    @Override
    public boolean canLearn(SkillContext context) {
        if (!super.canLearn(context)) {
            return false;
        }
        if (context.getAdditionalLearnPoints() < this.learnKnowledgeCost) {
            return false;
        }
        return this.canUnlockTier(context);
    }

    public boolean canUnlockTier(SkillContext context) {
        PrestigeTree tree;
        if (this.tierLock > 0 && this.tier > 1 && (tree = (PrestigeTree)this.up((skill, val) -> {
            PrestigeTree pt;
            return val != null ? val : (skill instanceof PrestigeTree ? (pt = (PrestigeTree)skill) : null);
        }, null)) != null) {
            int usedPrev;
            HashMap<Integer, Integer> spent = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> used = new HashMap<Integer, Integer>();
            for (PrestigePower power : tree.getAll(PrestigePower.class, p -> p.isUnlocked() && p != this)) {
                spent.merge(power.getTier(), power.getLearnPointCost(), Integer::sum);
                if (power.getTier() <= 1 || power.getTierLock() <= 0) continue;
                used.merge(power.getTier() - 1, power.getTierLock(), Integer::sum);
            }
            int spentPrev = spent.getOrDefault(this.tier - 1, 0);
            return spentPrev - (usedPrev = used.getOrDefault(this.tier - 1, 0).intValue()) >= this.tierLock;
        }
        return true;
    }

    @Override
    public void learn(SkillContext context) {
        super.learn(context);
        context.setAdditionalLearnPoints(context.getAdditionalLearnPoints() - this.learnKnowledgeCost);
    }

    @Override
    public void regret(SkillContext context) {
        super.regret(context);
        context.setAdditionalLearnPoints(context.getAdditionalLearnPoints() + this.learnKnowledgeCost);
    }

    public int getTier() {
        return this.tier;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.learnKnowledgeCost, buffer);
        Adapters.INT.writeBits(this.tier, buffer);
        Adapters.INT.writeBits(this.tierLock, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.learnKnowledgeCost = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.tier = Adapters.INT.readBits(buffer).orElse(0);
        this.tierLock = Adapters.INT.readBits(buffer).orElse(0);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.learnKnowledgeCost).ifPresent(tag -> nbt.m_128365_("learnKnowledgeCost", tag));
            Adapters.INT.writeNbt(this.tier).ifPresent(tag -> nbt.m_128365_("tier", tag));
            Adapters.INT.writeNbt(this.tierLock).ifPresent(tag -> nbt.m_128365_("tierLock", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.learnKnowledgeCost = Adapters.INT.readNbt(nbt.m_128423_("learnKnowledgeCost")).orElse(0);
        this.tier = Adapters.INT.readNbt(nbt.m_128423_("tier")).orElse(0);
        this.tierLock = Adapters.INT.readNbt(nbt.m_128423_("tierLock")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.learnKnowledgeCost).ifPresent(element -> json.add("learnKnowledgeCost", element));
            Adapters.INT.writeJson(this.tier).ifPresent(element -> json.add("tier", element));
            Adapters.INT.writeJson(this.tierLock).ifPresent(element -> json.add("tierLock", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.learnKnowledgeCost = Adapters.INT.readJson(json.get("learnKnowledgeCost")).orElse(0);
        this.tier = Adapters.INT.readJson(json.get("tier")).orElse(0);
        this.tierLock = Adapters.INT.readJson(json.get("tierLock")).orElse(0);
    }
}

