/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.prestige.core;

import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.gear.trinket.TrinketEffectRegistry;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.prestige.core.PrestigePower;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class TrinketPrestigePower
extends PrestigePower
implements TickingSkill {
    private ResourceLocation trinketEffectId;

    public TrinketPrestigePower() {
        this.trinketEffectId = null;
    }

    public TrinketPrestigePower(ResourceLocation trinketEffectId) {
        this.trinketEffectId = trinketEffectId;
    }

    @Nullable
    public ResourceLocation getTrinketEffectId() {
        return this.trinketEffectId;
    }

    @Nullable
    public TrinketEffect<?> getTrinketEffect() {
        return TrinketEffectRegistry.getEffect(this.getTrinketEffectId());
    }

    @Override
    public void onAdd(SkillContext context) {
        super.onAdd(context);
        context.getSource().as(LivingEntity.class).ifPresent(entity -> {
            if (this.getTrinketEffect() == null) {
                return;
            }
            this.getTrinketEffect().onEquip((LivingEntity)entity, null);
        });
    }

    @Override
    public void onRemove(SkillContext context) {
        super.onRemove(context);
        context.getSource().as(LivingEntity.class).ifPresent(entity -> {
            if (this.getTrinketEffect() == null) {
                return;
            }
            this.getTrinketEffect().onUnEquip((LivingEntity)entity, null);
        });
    }

    @Override
    public void onTick(SkillContext context) {
        if (!this.isUnlocked()) {
            return;
        }
        context.getSource().as(LivingEntity.class).ifPresent(entity -> {
            if (this.getTrinketEffect() == null) {
                return;
            }
            this.getTrinketEffect().onWornTick((LivingEntity)entity, null);
        });
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(SkillContext context) {
        if (!this.isUnlocked()) {
            return;
        }
        context.getSource().as(LocalPlayer.class).ifPresent(entity -> {
            if (this.getTrinketEffect() == null) {
                return;
            }
            this.getTrinketEffect().onWornTick((LivingEntity)entity, null);
        });
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.IDENTIFIER.asNullable().writeJson(this.trinketEffectId).ifPresent(jsonObject -> json.add("trinketEffectId", jsonObject));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.trinketEffectId = Adapters.IDENTIFIER.asNullable().readJson(json.get("trinketEffectId")).orElse(null);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.IDENTIFIER.asNullable().writeNbt(this.trinketEffectId).ifPresent(tag -> nbt.m_128365_("trinketEffectId", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.trinketEffectId = Adapters.IDENTIFIER.asNullable().readNbt(nbt.m_128423_("trinketEffectId")).orElse(null);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.IDENTIFIER.asNullable().writeBits(this.trinketEffectId, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.trinketEffectId = Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null);
    }

    @Override
    public void writeBytes(ByteBuf buffer) {
        super.writeBytes(buffer);
        Adapters.IDENTIFIER.asNullable().writeBytes(this.trinketEffectId, buffer);
    }

    @Override
    public void readBytes(ByteBuf buffer) {
        super.readBytes(buffer);
        this.trinketEffectId = Adapters.IDENTIFIER.asNullable().readBytes(buffer).orElse(null);
    }
}

