/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ConditionalDamageTalent
extends LearnableSkill {
    private MobEffect targetEffect;
    private double damageIncrease;

    public ConditionalDamageTalent(int unlockLevel, int learnPointCost, int regretPointCost, MobEffect targetEffect, double damageIncrease) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.targetEffect = targetEffect;
        this.damageIncrease = damageIncrease;
    }

    public ConditionalDamageTalent() {
    }

    public MobEffect getTargetEffect() {
        return this.targetEffect;
    }

    public double getDamageIncrease() {
        return this.damageIncrease;
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        Entity attackingEntity = event.getSource().m_7639_();
        if (!(attackingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)attackingEntity;
        LivingEntity attacked = event.getEntityLiving();
        float addedMultiplier = 0.0f;
        TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
        for (ConditionalDamageTalent talent : talents.getAll(ConditionalDamageTalent.class, Skill::isUnlocked)) {
            if (talent.getTargetEffect() == null || !attacked.m_21023_(talent.getTargetEffect())) continue;
            addedMultiplier = (float)((double)addedMultiplier + talent.getDamageIncrease());
        }
        event.setAmount(event.getAmount() * (1.0f + addedMultiplier));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.EFFECT.writeBits(this.targetEffect, buffer);
        Adapters.DOUBLE.writeBits(this.damageIncrease, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.targetEffect = Adapters.EFFECT.readBits(buffer).orElseThrow();
        this.damageIncrease = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.EFFECT.writeNbt(this.targetEffect).ifPresent(tag -> nbt.m_128365_("targetEffect", tag));
            Adapters.DOUBLE.writeNbt(this.damageIncrease).ifPresent(tag -> nbt.m_128365_("damageIncrease", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.targetEffect = Adapters.EFFECT.readNbt(nbt.m_128423_("targetEffect")).orElseThrow();
        this.damageIncrease = (Double)Adapters.DOUBLE.readNbt(nbt.m_128423_("damageIncrease")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.EFFECT.writeJson(this.targetEffect).ifPresent(element -> json.add("targetEffect", element));
            Adapters.DOUBLE.writeJson(this.damageIncrease).ifPresent(element -> json.add("damageIncrease", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.targetEffect = Adapters.EFFECT.readJson(json.get("targetEffect")).orElseThrow();
        this.damageIncrease = (Double)Adapters.DOUBLE.readJson(json.get("damageIncrease")).orElseThrow();
    }
}

