/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class LightningDamageTalent
extends LearnableSkill {
    private float percentDamageDealt;

    public LightningDamageTalent(int unlockLevel, int learnPointCost, int regretPointCost, float percentDamageDealt) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.percentDamageDealt = percentDamageDealt;
    }

    public LightningDamageTalent() {
    }

    public float getIncreasedDamageDealtPercentage() {
        return this.percentDamageDealt;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.percentDamageDealt), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.percentDamageDealt = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.percentDamageDealt)).ifPresent(tag -> nbt.m_128365_("percentDamageDealt", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.percentDamageDealt = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("percentDamageDealt")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.percentDamageDealt)).ifPresent(element -> json.add("percentDamageDealt", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.percentDamageDealt = ((Float)Adapters.FLOAT.readJson(json.get("percentDamageDealt")).orElseThrow()).floatValue();
    }
}

