/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public class LightningStunTalent
extends LearnableSkill {
    private float stunChance;
    private float stunDuration;

    public LightningStunTalent(int unlockLevel, int learnPointCost, int regretPointCost, float stunChance, float stunDuration) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.stunChance = stunChance;
        this.stunDuration = stunDuration;
    }

    public LightningStunTalent() {
    }

    public float getStunChance() {
        return this.stunChance;
    }

    public float getStunDuration() {
        return this.stunDuration;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.stunChance), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.stunDuration), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.stunChance = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
        this.stunDuration = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.stunChance)).ifPresent(tag -> nbt.m_128365_("stunChance", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.stunDuration)).ifPresent(tag -> nbt.m_128365_("stunDuration", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.stunChance = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("stunChance")).orElseThrow()).floatValue();
        this.stunDuration = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("stunDuration")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.stunChance)).ifPresent(element -> json.add("stunChance", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.stunDuration)).ifPresent(element -> json.add("stunDuration", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.stunChance = ((Float)Adapters.FLOAT.readJson(json.get("stunChance")).orElseThrow()).floatValue();
        this.stunDuration = ((Float)Adapters.FLOAT.readJson(json.get("stunDuration")).orElseThrow()).floatValue();
    }
}

