/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.skill.base.LearnableSkill;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class PuristTalent
extends LearnableSkill {
    private Set<VaultGearRarity> rarities;
    private Set<EquipmentSlot> slots;
    private float damageIncrease;
    public static final ArrayAdapter<VaultGearRarity> RARITIES = Adapters.ofArray(VaultGearRarity[]::new, Adapters.ofEnum(VaultGearRarity.class, EnumAdapter.Mode.NAME));
    public static final ArrayAdapter<EquipmentSlot> SLOTS = Adapters.ofArray(EquipmentSlot[]::new, Adapters.ofEnum(EquipmentSlot.class, EnumAdapter.Mode.NAME));

    public Set<VaultGearRarity> getRarity() {
        return this.rarities;
    }

    public Set<EquipmentSlot> getSlots() {
        return this.slots;
    }

    public float getDamageIncrease() {
        return this.damageIncrease;
    }

    public int getCount(LivingEntity entity) {
        int count = 0;
        for (EquipmentSlot slot : this.slots) {
            VaultGearData gearData;
            Object data;
            ItemStack stack = entity.m_6844_(slot);
            if (!VaultGearData.hasData(stack) || !((data = AttributeGearData.read(stack)) instanceof VaultGearData) || !this.rarities.contains((Object)(gearData = (VaultGearData)data).getRarity())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        RARITIES.writeBits((VaultGearRarity)this.rarities.toArray(new VaultGearRarity[0]), buffer);
        SLOTS.writeBits((EquipmentSlot)this.slots.toArray(new EquipmentSlot[0]), buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageIncrease), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.rarities = Arrays.stream(RARITIES.readBits(buffer).orElse(new VaultGearRarity[0])).collect(Collectors.toSet());
        this.slots = Arrays.stream(SLOTS.readBits(buffer).orElse(new EquipmentSlot[0])).collect(Collectors.toSet());
        this.damageIncrease = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            RARITIES.writeNbt((VaultGearRarity)this.rarities.toArray(new VaultGearRarity[0])).ifPresent(tag -> nbt.m_128365_("rarities", tag));
            SLOTS.writeNbt((EquipmentSlot)this.slots.toArray(new EquipmentSlot[0])).ifPresent(tag -> nbt.m_128365_("slots", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageIncrease)).ifPresent(tag -> nbt.m_128365_("damageIncrease", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.rarities = Arrays.stream(RARITIES.readNbt(nbt.m_128423_("rarities")).orElse(new VaultGearRarity[0])).collect(Collectors.toSet());
        this.slots = Arrays.stream(SLOTS.readNbt(nbt.m_128423_("slots")).orElse(new EquipmentSlot[0])).collect(Collectors.toSet());
        this.damageIncrease = Adapters.FLOAT.readNbt(nbt.m_128423_("damageIncrease")).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            RARITIES.writeJson((VaultGearRarity)this.rarities.toArray(new VaultGearRarity[0])).ifPresent(tag -> json.add("rarities", tag));
            SLOTS.writeJson((EquipmentSlot)this.slots.toArray(new EquipmentSlot[0])).ifPresent(tag -> json.add("slots", tag));
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageIncrease)).ifPresent(tag -> json.add("damageIncrease", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.rarities = Arrays.stream(RARITIES.readJson(json.get("rarities")).orElse(new VaultGearRarity[0])).collect(Collectors.toSet());
        this.slots = Arrays.stream(SLOTS.readJson(json.get("slots")).orElse(new EquipmentSlot[0])).collect(Collectors.toSet());
        this.damageIncrease = Adapters.FLOAT.readJson(json.get("damageIncrease")).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

