/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.gear.VaultGearHelper;
import iskallia.vault.gear.attribute.VaultGearAttribute;
import iskallia.vault.gear.attribute.VaultGearAttributeInstance;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.talent.type.GearAttributeTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.calc.EffectDurationHelper;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.EventPriority;

public class StackingGearAttributeTalent
extends GearAttributeTalent {
    private MobEffect effect;
    private int durationTicks;
    private int maxStacks;
    private int timeLeft;
    private int stacks;

    public StackingGearAttributeTalent(int unlockLevel, int learnPointCost, int regretPointCost, VaultGearAttribute<?> attribute, double value, MobEffect effect, int durationTicks, int maxStacks) {
        super(unlockLevel, learnPointCost, regretPointCost, attribute, value);
        this.effect = effect;
        this.durationTicks = durationTicks;
        this.maxStacks = maxStacks;
    }

    public StackingGearAttributeTalent() {
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public int getUnmodifiedDurationTicks() {
        return this.durationTicks;
    }

    public int getDurationTicks(LivingEntity entity) {
        int duration = this.getUnmodifiedDurationTicks();
        return EffectDurationHelper.adjustEffectDurationFloor(entity, duration);
    }

    @Override
    public double getValue() {
        return super.getValue() * (double)this.stacks;
    }

    @Override
    public boolean canApply(SkillContext context) {
        return super.canApply(context) && this.timeLeft > 0 && this.stacks > 0;
    }

    @Override
    public void onTick(SkillContext context) {
        if (--this.timeLeft < 0 && this.isUnlocked() && this.stacks > 0) {
            this.timeLeft = 0;
            this.stacks = 0;
            context.getSource().as(ServerPlayer.class).ifPresent(this::refreshSnapshot);
        }
        super.onTick(context);
        if (this.isUnlocked() && this.effect != null && this.timeLeft > 0 && this.stacks > 0) {
            context.getSource().as(ServerPlayer.class).ifPresent(player -> {
                player.m_21195_(this.effect);
                player.m_7292_(new MobEffectInstance(this.effect, this.timeLeft, this.stacks - 1, true, false, true));
            });
        }
    }

    @Override
    public void onRemoveModifiers(SkillContext context) {
        context.getSource().as(LivingEntity.class).ifPresent(entity -> {
            Stream<VaultGearAttributeInstance<?>> attributesToRemove = Stream.of(VaultGearAttributeInstance.cast(this.getAttribute(), super.getValue()));
            VaultGearHelper.getModifiers(this.getUuid(), attributesToRemove).forEach((attribute, modifier) -> {
                AttributeInstance present = entity.m_21051_(attribute);
                if (present == null) {
                    return;
                }
                present.m_22120_(modifier.m_22209_());
            });
        });
    }

    public void onStack(ServerPlayer player) {
        if (++this.stacks > this.maxStacks) {
            this.stacks = this.maxStacks;
        }
        this.timeLeft = this.getDurationTicks((LivingEntity)player);
        this.refreshSnapshot(player);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.EFFECT.writeBits(this.effect, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.durationTicks, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.maxStacks, buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.timeLeft, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.stacks, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.effect = Adapters.EFFECT.readBits(buffer).orElseThrow();
        this.durationTicks = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.maxStacks = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.timeLeft = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.stacks = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.EFFECT.writeNbt(this.effect).ifPresent(tag -> nbt.m_128365_("effect", tag));
            Adapters.INT.writeNbt(this.durationTicks).ifPresent(tag -> nbt.m_128365_("durationTicks", tag));
            Adapters.INT.writeNbt(this.maxStacks).ifPresent(tag -> nbt.m_128365_("maxStacks", tag));
            Adapters.INT.writeNbt(this.timeLeft).ifPresent(tag -> nbt.m_128365_("timeLeft", tag));
            Adapters.INT.writeNbt(this.stacks).ifPresent(tag -> nbt.m_128365_("stacks", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.effect = Adapters.EFFECT.readNbt(nbt.m_128423_("effect")).orElseThrow(() -> new IllegalStateException("Unknown effect in " + String.valueOf(nbt)));
        this.durationTicks = Adapters.INT.readNbt(nbt.m_128423_("durationTicks")).orElse(0);
        this.maxStacks = Adapters.INT.readNbt(nbt.m_128423_("maxStacks")).orElse(0);
        this.timeLeft = Adapters.INT.readNbt(nbt.m_128423_("timeLeft")).orElse(0);
        this.stacks = Adapters.INT.readNbt(nbt.m_128423_("stacks")).orElse(0);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.EFFECT.writeJson(this.effect).ifPresent(element -> json.add("effect", element));
            Adapters.INT.writeJson(this.durationTicks).ifPresent(element -> json.add("durationTicks", element));
            Adapters.INT.writeJson(this.maxStacks).ifPresent(element -> json.add("maxStacks", element));
            Adapters.INT.writeJson(this.timeLeft).ifPresent(element -> json.add("timeLeft", element));
            Adapters.INT.writeJson(this.stacks).ifPresent(element -> json.add("stacks", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.effect = Adapters.EFFECT.readJson(json.get("effect")).orElseThrow(() -> new IllegalStateException("Unknown effect in " + String.valueOf(json)));
        this.durationTicks = Adapters.INT.readJson(json.get("durationTicks")).orElse(0);
        this.maxStacks = Adapters.INT.readJson(json.get("maxStacks")).orElse(0);
        this.timeLeft = Adapters.INT.readJson(json.get("timeLeft")).orElse(0);
        this.stacks = Adapters.INT.readJson(json.get("stacks")).orElse(0);
    }

    static {
        CommonEvents.ENTITY_DROPS.register(StackingGearAttributeTalent.class, EventPriority.HIGHEST, event -> {
            ServerPlayer player;
            Entity attacker;
            block7: {
                block6: {
                    attacker = event.getSource().m_7639_();
                    if (!(attacker instanceof ServerPlayer)) break block6;
                    player = (ServerPlayer)attacker;
                    if (!attacker.m_183503_().m_5776_()) break block7;
                }
                return;
            }
            if (attacker.m_183503_() != event.getEntity().m_183503_()) {
                return;
            }
            if (player.m_20194_() == null) {
                return;
            }
            ServerPlayer existing = player.m_20194_().m_6846_().m_11259_(player.m_142081_());
            if (existing != player) {
                return;
            }
            TalentTree tree = PlayerTalentsData.get(attacker.m_20194_()).getTalents((Player)player);
            tree.getAll(StackingGearAttributeTalent.class, Skill::isUnlocked).forEach(talent -> talent.onStack(player));
        });
    }
}

