/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.health;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.talent.type.health.LowHealthTalent;
import iskallia.vault.util.damage.PlayerDamageHelper;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public class LowHealthDamageTalent
extends LowHealthTalent
implements TickingSkill {
    private static final UUID DAMAGE_MULTIPLIER_ID = UUID.fromString("125493ba-f280-4246-af3c-b603e08ce12f");
    private float damageIncrease;

    public LowHealthDamageTalent(int unlockLevel, int learnPointCost, int regretPointCost, float healthThreshold, MobEffect effect, float damageIncrease) {
        super(unlockLevel, learnPointCost, regretPointCost, healthThreshold, effect);
        this.damageIncrease = damageIncrease;
    }

    public LowHealthDamageTalent() {
    }

    @Override
    public void onRemove(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(this::removeExistingDamageBuff);
    }

    @Override
    public void onTick(SkillContext context) {
        super.onTick(context);
        if (!this.isUnlocked()) {
            return;
        }
        context.getSource().as(ServerPlayer.class).ifPresent(player -> {
            if (!this.shouldGetBenefits((LivingEntity)player)) {
                this.removeExistingDamageBuff((ServerPlayer)player);
                return;
            }
            PlayerDamageHelper.DamageMultiplier existing = PlayerDamageHelper.getMultiplier(player, DAMAGE_MULTIPLIER_ID);
            if (existing != null && !Mth.m_14033_((float)existing.getMultiplier(), (float)this.damageIncrease)) {
                PlayerDamageHelper.removeMultiplier(player, existing);
                existing = null;
            }
            if (existing == null) {
                PlayerDamageHelper.applyTimedMultiplier(DAMAGE_MULTIPLIER_ID, player, this.damageIncrease, PlayerDamageHelper.Operation.ADDITIVE_MULTIPLY, true, 20);
            } else {
                existing.refreshDuration(player.m_20194_());
            }
        });
    }

    private void removeExistingDamageBuff(ServerPlayer player) {
        PlayerDamageHelper.DamageMultiplier existing = PlayerDamageHelper.getMultiplier(player, DAMAGE_MULTIPLIER_ID);
        if (existing != null) {
            PlayerDamageHelper.removeMultiplier(player, existing);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageIncrease), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageIncrease = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageIncrease)).ifPresent(tag -> nbt.m_128365_("damageIncrease", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageIncrease = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damageIncrease")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageIncrease)).ifPresent(element -> json.add("damageIncrease", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageIncrease = ((Float)Adapters.FLOAT.readJson(json.get("damageIncrease")).orElseThrow()).floatValue();
    }
}

