/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.health;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.talent.type.health.ConditionalEntitySkill;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;

public abstract class LowHealthTalent
extends ConditionalEntitySkill {
    private float healthThreshold;

    public LowHealthTalent(int unlockLevel, int learnPointCost, int regretPointCost, float healthThreshold, MobEffect effect) {
        super(unlockLevel, learnPointCost, regretPointCost, effect);
        this.healthThreshold = healthThreshold;
    }

    protected LowHealthTalent() {
    }

    @Override
    public boolean shouldGetBenefits(LivingEntity entity) {
        return entity.m_21223_() < this.healthThreshold * entity.m_21233_();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.healthThreshold), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.healthThreshold = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.healthThreshold)).ifPresent(tag -> nbt.m_128365_("healthThreshold", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.healthThreshold = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("healthThreshold")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.healthThreshold)).ifPresent(element -> json.add("healthThreshold", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.healthThreshold = ((Float)Adapters.FLOAT.readJson(json.get("healthThreshold")).orElseThrow()).floatValue();
    }
}

