/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.luckyhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.LuckyHitDamageParticleMessage;
import iskallia.vault.skill.talent.type.luckyhit.LuckyHitTalent;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class DamageLuckyHitTalent
extends LuckyHitTalent {
    private float damageIncrease;

    public DamageLuckyHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, float damageIncrease) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.damageIncrease = damageIncrease;
    }

    public DamageLuckyHitTalent() {
    }

    @Override
    public void onLuckyHit(LivingHurtEvent event) {
        event.setAmount(event.getAmount() * (1.0f + this.damageIncrease));
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new LuckyHitDamageParticleMessage(new Vec3(event.getEntity().m_20182_().f_82479_, event.getEntity().m_20182_().f_82480_ + (double)(event.getEntity().m_20206_() / 2.0f), event.getEntity().m_20182_().f_82481_), new Vec3((double)(event.getEntity().m_20205_() / 2.0f), (double)(event.getEntity().m_20206_() / 2.0f), (double)(event.getEntity().m_20205_() / 2.0f)), event.getEntity().m_142049_()));
    }

    public float getDamageIncrease() {
        return this.damageIncrease;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageIncrease), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageIncrease = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageIncrease)).ifPresent(tag -> nbt.m_128365_("damageIncrease", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageIncrease = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damageIncrease")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageIncrease)).ifPresent(element -> json.add("damageIncrease", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageIncrease = ((Float)Adapters.FLOAT.readJson(json.get("damageIncrease")).orElseThrow()).floatValue();
    }
}

