/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.luckyhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.LuckyHitLeechParticleMessage;
import iskallia.vault.skill.talent.type.luckyhit.LuckyHitTalent;
import iskallia.vault.util.PlayerLeechHelper;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.network.PacketDistributor;

public class HealthLeechLuckyHitTalent
extends LuckyHitTalent {
    private float maxHealthPercentage;

    public HealthLeechLuckyHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, float maxHealthPercentage) {
        super(unlockLevel, learnPointCost, regretPointCost);
        this.maxHealthPercentage = maxHealthPercentage;
    }

    public HealthLeechLuckyHitTalent() {
    }

    @Override
    public void onLuckyHit(LivingHurtEvent event) {
        Entity entity;
        if (!event.getEntity().f_19853_.m_5776_() && (entity = event.getSource().m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            LivingEntity attacked = event.getEntityLiving();
            PlayerLeechHelper.onLeech(attacker, attacked, event.getAmount(), this.maxHealthPercentage);
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new LuckyHitLeechParticleMessage(new Vec3(attacked.m_20185_(), attacked.m_20186_() + (double)0.15f, attacked.m_20189_()), attacker.m_142049_(), 16150747, 20));
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.maxHealthPercentage), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.maxHealthPercentage = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.maxHealthPercentage)).ifPresent(tag -> nbt.m_128365_("maxHealthPercentage", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.maxHealthPercentage = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("maxHealthPercentage")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.maxHealthPercentage)).ifPresent(element -> json.add("maxHealthPercentage", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.maxHealthPercentage = ((Float)Adapters.FLOAT.readJson(json.get("maxHealthPercentage")).orElseThrow()).floatValue();
    }
}

