/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.luckyhit;

import com.mojang.datafixers.util.Pair;
import iskallia.vault.VaultMod;
import iskallia.vault.event.ActiveFlagsCheck;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.etching.EtchingGearAttributes;
import iskallia.vault.gear.etching.EtchingHelper;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.gear.VaultShieldItem;
import iskallia.vault.network.message.BonkParticleMessage;
import iskallia.vault.network.message.LuckyHitParticleMessage;
import iskallia.vault.skill.ability.effect.BonkLuckyStrikeAbility;
import iskallia.vault.skill.ability.effect.NovaSpeedAbility;
import iskallia.vault.skill.ability.effect.spi.core.Ability;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.talent.type.luckyhit.SweepingLuckyHitTalent;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.Throuple;
import iskallia.vault.util.VortexHelper;
import iskallia.vault.util.calc.LuckyHitHelper;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.util.damage.ThornsReflectDamageSource;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class LuckyHitTalent
extends LearnableSkill {
    public LuckyHitTalent(int unlockLevel, int learnPointCost, int regretPointCost) {
        super(unlockLevel, learnPointCost, regretPointCost);
    }

    protected LuckyHitTalent() {
    }

    public abstract void onLuckyHit(LivingHurtEvent var1);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void doLuckyHit(LivingHurtEvent event) {
        SweepingLuckyHitTalent cleave;
        ServerPlayer attacker;
        Entity source;
        if (ActiveFlagsCheck.isAnyFlagActiveLuckyHit()) {
            return;
        }
        boolean isThorns = false;
        if (event.getSource() instanceof ThornsReflectDamageSource) {
            isThorns = true;
            source = event.getSource().m_7639_();
            if (!(source instanceof ServerPlayer)) {
                return;
            }
            attacker = (ServerPlayer)source;
            if (!attacker.m_6844_(EquipmentSlot.OFFHAND).m_41619_()) {
                ItemStack stack2 = attacker.m_6844_(EquipmentSlot.OFFHAND);
                if (!(stack2.m_41720_() instanceof VaultShieldItem)) {
                    return;
                }
                VaultGearData data = VaultGearData.read(stack2);
                if (!data.getFirstValue(ModGearAttributes.LUCKY_THORNS).orElse(false).booleanValue()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (!((source = event.getSource().m_7639_()) instanceof ServerPlayer)) {
            return;
        }
        attacker = (ServerPlayer)source;
        if (!isThorns && CritHelper.getCrit((Player)attacker)) {
            return;
        }
        if (!isThorns && AttackScaleHelper.getLastAttackScale((Player)attacker) < 1.0f) {
            return;
        }
        float probability = LuckyHitHelper.getLuckyHitChance((LivingEntity)attacker);
        MobEffectInstance battleCry = attacker.m_21124_(ModEffects.BATTLE_CRY_LUCKY_STRIKE);
        if (battleCry != null && !isThorns) {
            AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)attacker.f_19853_).getAbilities((Player)attacker);
            for (BonkLuckyStrikeAbility ability : abilities.getAll(BonkLuckyStrikeAbility.class, Skill::isUnlocked)) {
                int stacksUsed = ability.getMaxStacksUsedPerHit();
                MobEffectInstance newBattleCry = null;
                if (battleCry.m_19564_() - stacksUsed >= 0) {
                    newBattleCry = new MobEffectInstance(battleCry.m_19544_(), battleCry.m_19557_(), battleCry.m_19564_() - stacksUsed, false, false, true);
                } else {
                    stacksUsed = battleCry.m_19564_() + 1;
                }
                probability += ability.getLuckyHitChancePerStack() * (float)stacksUsed;
                attacker.f_19853_.m_6263_((Player)attacker, attacker.m_20182_().f_82479_, attacker.m_20182_().f_82480_, attacker.m_20182_().f_82481_, ModSounds.BONK, SoundSource.PLAYERS, 1.0f, 0.7f);
                attacker.m_6330_(ModSounds.BONK, SoundSource.PLAYERS, 1.0f, 0.7f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new BonkParticleMessage(new Vec3(attacker.m_20185_(), attacker.m_20186_() + (double)(attacker.m_20206_() / 3.0f), attacker.m_20189_()), event.getEntity().m_142049_(), 7206307, 5 * stacksUsed, 5 + (int)(new Random().nextFloat() * 10.0f)));
                attacker.m_21195_(ModEffects.BATTLE_CRY_LUCKY_STRIKE);
                if (newBattleCry == null) continue;
                attacker.m_7292_(newBattleCry);
            }
        }
        if (attacker.m_183503_().m_5822_().nextFloat() >= probability) {
            return;
        }
        EtchingHelper.getEtchings((LivingEntity)attacker, EtchingGearAttributes.LUCKY_FROST_NOVA).stream().findFirst().ifPresent(stack -> {
            int level = (Integer)stack.getValue();
            ModConfigs.ABILITIES.getAbilityById("Nova_Slow").filter(s -> s instanceof TieredSkill).map(s -> (TieredSkill)s).ifPresent(tiered -> {
                int idx = Math.max(1, Math.min(level, tiered.getTiers().size()));
                LearnableSkill child = tiered.getChild(idx);
                if (child instanceof NovaSpeedAbility) {
                    NovaSpeedAbility nova = (NovaSpeedAbility)child;
                    nova.doAction(SkillContext.of(attacker));
                } else {
                    VaultMod.LOGGER.error("LuckyFrostNovaEtching level {} is not NovaSpeedAbility", (Object)idx);
                }
            });
        });
        EtchingHelper.getEtchings((LivingEntity)attacker, EtchingGearAttributes.LUCKY_VULNERABLE).stream().findFirst().ifPresent(stack -> {
            String effectId = (String)((Throuple)stack.getValue()).getFirst();
            MobEffect effect = ModEffects.VULNERABLE;
            if (!effectId.isEmpty() && (effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectId))) == null) {
                VaultMod.LOGGER.error("Unknown effect {} for TotemPlayerDamageEffectEtching", (Object)effectId);
                effect = ModEffects.VULNERABLE;
            }
            int level = (Integer)((Throuple)stack.getValue()).getThird();
            float duration = ((Float)((Throuple)stack.getValue()).getSecond()).floatValue();
            event.getEntityLiving().m_7292_(new MobEffectInstance(effect, (int)(duration * 20.0f), Math.max(0, Math.min(8, level) - 1), false, false));
        });
        EtchingHelper.getEtchings((LivingEntity)attacker, EtchingGearAttributes.LUCKY_VORTEX).stream().findFirst().ifPresent(stack -> {
            float radius = ((Float)((Pair)stack.getValue()).getFirst()).floatValue();
            double duration = ((Float)((Pair)stack.getValue()).getSecond()).floatValue();
            Vec3 center = event.getEntity().m_20182_();
            VortexHelper.spawn((ServerLevel)attacker.f_19853_, center, radius, (int)(duration * 20.0), (LivingEntity)attacker);
        });
        EtchingHelper.getEtchings((LivingEntity)attacker, EtchingGearAttributes.LUCKY_COOLDOWN_RESET).stream().findFirst().ifPresent(stack -> {
            String abilityId = (String)stack.getValue();
            if (!abilityId.isEmpty()) {
                AbilityTree abilities = PlayerAbilitiesData.get((ServerLevel)attacker.f_19853_).getAbilities((Player)attacker);
                abilities.getForId(abilityId).ifPresent(skill -> {
                    if (skill instanceof SpecializedSkill) {
                        SpecializedSkill specialized = (SpecializedSkill)skill;
                        skill = specialized.getSpecialization();
                    }
                    if (skill instanceof TieredSkill) {
                        TieredSkill tiered = (TieredSkill)skill;
                        skill = tiered.getChild();
                    }
                    if (skill instanceof Ability) {
                        Ability ability = (Ability)skill;
                        ability.getCooldown().ifPresent(c -> ability.reduceCooldownBy(c.getRemainingTicks()));
                    } else {
                        VaultMod.LOGGER.warn("LuckyCooldownResetEtching ability {} is not an Ability", (Object)abilityId);
                    }
                });
            } else {
                VaultMod.LOGGER.warn("LuckyCooldownResetEtching missing ability id");
            }
        });
        TalentTree tree = PlayerTalentsData.get((ServerLevel)attacker.f_19853_).getTalents((Player)attacker);
        boolean hasLuckyHit = false;
        List<LuckyHitTalent> luckyHitTalents = tree.getAll(LuckyHitTalent.class, Skill::isUnlocked);
        for (LuckyHitTalent talent : luckyHitTalents) {
            if (!(talent instanceof SweepingLuckyHitTalent)) continue;
            cleave = (SweepingLuckyHitTalent)talent;
            talent.onLuckyHit(event);
            hasLuckyHit = true;
        }
        for (LuckyHitTalent talent : luckyHitTalents) {
            if (talent instanceof SweepingLuckyHitTalent) {
                cleave = (SweepingLuckyHitTalent)talent;
                continue;
            }
            talent.onLuckyHit(event);
            hasLuckyHit = true;
        }
        if (!hasLuckyHit) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        event.getEntity().m_183503_().m_6269_(null, event.getEntity(), SoundEvents.f_12313_, SoundSource.BLOCKS, 1.0f, 1.75f);
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new LuckyHitParticleMessage(new Vec3(event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)event.getEntity().m_20206_(), event.getEntity().m_20189_())));
    }
}

