/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.onhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.event.ActiveFlags;
import iskallia.vault.mana.FullManaPlayer;
import iskallia.vault.skill.ability.effect.spi.core.InstantAbility;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.skill.talent.type.EntityFilterTalent;
import iskallia.vault.skill.talent.type.JavelinConductTalent;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.damage.AttackScaleHelper;
import iskallia.vault.util.damage.CritHelper;
import iskallia.vault.world.data.PlayerAbilitiesData;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CastOnHitTalent
extends EntityFilterTalent {
    private String ability;
    private float probability;

    public CastOnHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, EntityPredicate[] filter, String ability, float probability) {
        super(unlockLevel, learnPointCost, regretPointCost, filter);
        this.ability = ability;
        this.probability = probability;
    }

    public CastOnHitTalent() {
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        Entity attacker;
        if (ActiveFlags.IS_AOE_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_TOTEM_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_CHARMED_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_DOT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_REFLECT_ATTACKING.isSet()) {
            return;
        }
        if (ActiveFlags.IS_EFFECT_ATTACKING.isSet()) {
            return;
        }
        boolean hasConduct = false;
        if (ActiveFlags.IS_JAVELIN_ATTACKING.isSet()) {
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)entity;
                TalentTree talents = PlayerTalentsData.get(sPlayer.m_183503_()).getTalents((Player)sPlayer);
                for (JavelinConductTalent talent : talents.getAll(JavelinConductTalent.class, Skill::isUnlocked)) {
                    hasConduct = true;
                }
            }
            if (!hasConduct) {
                return;
            }
        }
        if (!((attacker = event.getSource().m_7639_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)attacker;
        if (!hasConduct && CritHelper.getCrit((Player)player)) {
            return;
        }
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        if (!hasConduct && AttackScaleHelper.getLastAttackScale((Player)player) < 1.0f) {
            return;
        }
        for (CastOnHitTalent talent : talents.getAll(CastOnHitTalent.class, Skill::isUnlocked)) {
            if (!talent.isValid(event.getEntity())) continue;
            if (player.m_183503_().m_5822_().nextFloat() >= talent.probability) {
                return;
            }
            AbilityTree tree = PlayerAbilitiesData.get((ServerLevel)player.f_19853_).getAbilities((Player)player);
            talent.resolve(tree, (Player)player).ifPresent(ability -> ability.onAction(SkillContext.of(player, SkillSource.of((Entity)player).setPos(event.getEntity().m_20182_()).setMana(FullManaPlayer.INSTANCE))));
        }
    }

    public Optional<InstantAbility> resolve(AbilityTree tree, Player player) {
        return tree.getForId(this.ability).map(skill -> {
            Skill skill2;
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                v0 = specialized.getSpecialization();
            } else {
                v0 = skill = skill;
            }
            if (skill instanceof TieredSkill) {
                TieredSkill tiered = (TieredSkill)skill;
                skill2 = tiered.getChild();
            } else {
                skill2 = skill;
            }
            skill = skill2;
            return (InstantAbility)(skill instanceof InstantAbility ? skill : null);
        });
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.UTF_8.writeBits(this.ability, buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.probability), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.ability = Adapters.UTF_8.readBits(buffer).orElseThrow();
        this.probability = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.UTF_8.writeNbt(this.ability).ifPresent(tag -> nbt.m_128365_("ability", tag));
            Adapters.FLOAT.writeNbt(Float.valueOf(this.probability)).ifPresent(tag -> nbt.m_128365_("probability", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.ability = Adapters.UTF_8.readNbt(nbt.m_128423_("ability")).orElseThrow();
        this.probability = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("probability")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.UTF_8.writeJson(this.ability).ifPresent(element -> json.add("ability", element));
            Adapters.FLOAT.writeJson(Float.valueOf(this.probability)).ifPresent(element -> json.add("probability", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.ability = Adapters.UTF_8.readJson(json.get("ability")).orElseThrow();
        this.probability = ((Float)Adapters.FLOAT.readJson(json.get("probability")).orElseThrow()).floatValue();
    }
}

