/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.talent.type.onhit;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.talent.type.EntityFilterTalent;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.world.data.PlayerTalentsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageOnHitTalent
extends EntityFilterTalent {
    private float damageIncrease;

    public DamageOnHitTalent(int unlockLevel, int learnPointCost, int regretPointCost, EntityPredicate[] filter, float damageIncrease) {
        super(unlockLevel, learnPointCost, regretPointCost, filter);
        this.damageIncrease = damageIncrease;
    }

    public DamageOnHitTalent() {
    }

    @SubscribeEvent
    public static void onAttack(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (!(attacker instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)attacker;
        TalentTree talents = PlayerTalentsData.get(player.m_183503_()).getTalents((Player)player);
        float damageIncrease = 0.0f;
        for (DamageOnHitTalent talent : talents.getAll(DamageOnHitTalent.class, Skill::isUnlocked)) {
            if (!talent.isValid(event.getEntity())) continue;
            damageIncrease += talent.damageIncrease;
        }
        event.setAmount(event.getAmount() * (1.0f + damageIncrease));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.FLOAT.writeBits(Float.valueOf(this.damageIncrease), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.damageIncrease = ((Float)Adapters.FLOAT.readBits(buffer).orElseThrow()).floatValue();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.FLOAT.writeNbt(Float.valueOf(this.damageIncrease)).ifPresent(tag -> nbt.m_128365_("damageIncrease", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.damageIncrease = ((Float)Adapters.FLOAT.readNbt(nbt.m_128423_("damageIncrease")).orElseThrow()).floatValue();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.FLOAT.writeJson(Float.valueOf(this.damageIncrease)).ifPresent(element -> json.add("damageIncrease", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.damageIncrease = ((Float)Adapters.FLOAT.readJson(json.get("damageIncrease")).orElseThrow()).floatValue();
    }
}

