/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.tree;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.KnownPrestigePowersMessage;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.TickingSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.prestige.core.ActivatePrestigePower;
import iskallia.vault.skill.prestige.core.PrestigePower;
import iskallia.vault.skill.tree.SkillTree;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;

public class PrestigeTree
extends SkillTree
implements TickingSkill {
    private static final ArrayAdapter<Skill> SKILLS = Adapters.ofArray(Skill[]::new, Adapters.SKILL);

    @Override
    public int getSpentLearnPoints() {
        int points = 0;
        for (Skill skill : this.skills) {
            if (!(skill instanceof PrestigePower)) continue;
            PrestigePower power = (PrestigePower)skill;
            points += power.getSpentLearnPoints();
        }
        return points;
    }

    public int getSpentAdditionalLearnPoints() {
        int points = 0;
        for (Skill skill : this.skills) {
            if (!(skill instanceof PrestigePower)) continue;
            PrestigePower power = (PrestigePower)skill;
            points += power.getLearnKnowledgeCost();
        }
        return points;
    }

    @Override
    public Skill mergeFrom(Skill other, SkillContext context) {
        if (!(other instanceof PrestigeTree)) {
            return other;
        }
        PrestigeTree tree = (PrestigeTree)other;
        LinkedHashMap<String, Skill> idToSkill = new LinkedHashMap<String, Skill>();
        LinkedHashMap<String, Integer> idToIndex = new LinkedHashMap<String, Integer>();
        for (int index = 0; index < tree.skills.size(); ++index) {
            Skill skill = (Skill)tree.skills.get(index);
            idToSkill.put(skill.getId(), skill);
            idToIndex.put(skill.getId(), index);
        }
        for (Skill savedSkill : this.skills) {
            if (savedSkill.getId() == null || !idToSkill.containsKey(savedSkill.getId())) continue;
            Skill configSkill = (Skill)idToSkill.get(savedSkill.getId());
            Skill restored = savedSkill.mergeFrom(configSkill, context);
            tree.skills.set((Integer)idToIndex.get(savedSkill.getId()), restored);
        }
        return tree;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        SKILLS.writeBits((Skill)((Skill[])this.skills.toArray(Skill[]::new)), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.skills = Arrays.stream((Skill[])SKILLS.readBits(buffer).orElseThrow()).collect(Collectors.toList());
        this.skills.forEach(skill -> skill.setParent(this));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            SKILLS.writeNbt((Skill)((Skill[])this.skills.toArray(Skill[]::new))).ifPresent(tag -> nbt.m_128365_("skills", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.skills = Arrays.stream((Skill[])SKILLS.readNbt(nbt.m_128423_("skills")).orElseThrow()).collect(Collectors.toList());
        this.skills.forEach(skill -> skill.setParent(this));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            SKILLS.writeJson((Skill)((Skill[])this.skills.toArray(Skill[]::new))).ifPresent(element -> json.add("skills", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.skills = Arrays.stream((Skill[])SKILLS.readJson(json.get("skills")).orElseThrow()).collect(Collectors.toList());
        this.skills.forEach(skill -> skill.setParent(this));
    }

    public boolean hasActive(Class<? extends ActivatePrestigePower> activateClass) {
        return this.getAll(TieredSkill.class, TieredSkill::isUnlocked).stream().filter(skill -> skill.getChild() instanceof ActivatePrestigePower).map(skill -> (ActivatePrestigePower)skill.getChild()).anyMatch(activatePrestigePower -> activateClass.isInstance(activatePrestigePower) && activatePrestigePower.isActive());
    }

    public void sync(SkillContext context) {
        context.getSource().as(ServerPlayer.class).ifPresent(player -> ModNetwork.CHANNEL.sendTo((Object)new KnownPrestigePowersMessage(this), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
    }
}

