/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.skill.tree;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TickingSkill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;

public class SkillTree
extends LearnableSkill
implements TickingSkill {
    public List<Skill> skills = new ArrayList<Skill>();
    private static final ArrayAdapter<Skill> SKILLS = Adapters.ofArray(Skill[]::new, Adapters.SKILL);

    @Override
    public int getSpentLearnPoints() {
        int points = 0;
        for (Skill skill : this.skills) {
            if (!(skill instanceof LearnableSkill)) continue;
            points += ((LearnableSkill)skill).getSpentLearnPoints();
        }
        return points;
    }

    @Override
    public Optional<Skill> getForId(String id) {
        return super.getForId(id).or(() -> {
            for (Skill child : this.skills) {
                Skill skill = child.getForId(id).orElse(null);
                if (skill == null) continue;
                return Optional.of(skill);
            }
            return Optional.empty();
        });
    }

    @Override
    public <T> void iterate(Class<T> type, Consumer<T> action) {
        super.iterate(type, action);
        for (Skill child : this.skills) {
            child.iterate(type, action);
        }
    }

    @Override
    public void onTick(SkillContext context) {
        this.iterate(TickingSkill.class, skill -> {
            if (skill != this) {
                skill.onTick(context);
            }
        });
    }

    @Override
    public void onClientTick(SkillContext context) {
        this.iterate(TickingSkill.class, skill -> {
            if (skill != this) {
                skill.onClientTick(context);
            }
        });
    }

    public void learn(String id, SkillContext context) {
        this.getForId(id).ifPresent(skill -> {
            if (skill instanceof LearnableSkill) {
                LearnableSkill learnable = (LearnableSkill)skill;
                if (!learnable.canLearn(context)) {
                    return;
                }
                learnable.learn(context);
            }
        });
    }

    public void regret(String id, SkillContext context) {
        this.getForId(id).ifPresent(skill -> {
            if (skill instanceof LearnableSkill) {
                LearnableSkill learnable = (LearnableSkill)skill;
                if (!learnable.canRegret(context)) {
                    return;
                }
                learnable.regret(context);
            }
        });
    }

    public void specialize(String id, int index, SkillContext context) {
        this.getForId(id).ifPresent(skill -> {
            if (skill instanceof SpecializedSkill) {
                SpecializedSkill specialized = (SpecializedSkill)skill;
                specialized.specialize(index, context);
            }
        });
    }

    @Override
    public Skill mergeFrom(Skill other, SkillContext context) {
        if (!(other instanceof SkillTree)) {
            context.setLearnPoints(context.getLearnPoints() + this.getSpentLearnPoints());
            return other;
        }
        SkillTree tree = (SkillTree)other;
        LinkedHashMap<String, Skill> idToSkill = new LinkedHashMap<String, Skill>();
        LinkedHashMap<String, Integer> idToIndex = new LinkedHashMap<String, Integer>();
        for (int index = 0; index < tree.skills.size(); ++index) {
            Skill skill = tree.skills.get(index);
            idToSkill.put(skill.getId(), skill);
            idToIndex.put(skill.getId(), index);
        }
        for (Skill child : this.skills) {
            Skill merged = child.getId() == null || !idToSkill.containsKey(child.getId()) ? child.mergeFrom(null, context) : child.mergeFrom((Skill)idToSkill.get(child.getId()), context);
            if (!idToIndex.containsKey(child.getId())) continue;
            tree.skills.set((Integer)idToIndex.get(child.getId()), merged);
        }
        return tree;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        SKILLS.writeBits((Skill)((Skill[])this.skills.toArray(Skill[]::new)), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.skills = Arrays.stream((Skill[])SKILLS.readBits(buffer).orElseThrow()).collect(Collectors.toList());
        this.skills.forEach(skill -> skill.setParent(this));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            SKILLS.writeNbt((Skill)((Skill[])this.skills.toArray(Skill[]::new))).ifPresent(tag -> nbt.m_128365_("skills", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.skills = Arrays.stream((Skill[])SKILLS.readNbt(nbt.m_128423_("skills")).orElseThrow()).collect(Collectors.toList());
        this.skills.forEach(skill -> skill.setParent(this));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            SKILLS.writeJson((Skill)((Skill[])this.skills.toArray(Skill[]::new))).ifPresent(element -> json.add("skills", element));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.skills = Arrays.stream((Skill[])SKILLS.readJson(json.get("skills")).orElseThrow()).collect(Collectors.toList());
        this.skills.forEach(skill -> skill.setParent(this));
    }
}

