/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.snapshot;

import iskallia.vault.client.ClientEternalData;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.entity.eternal.EternalData;
import iskallia.vault.entity.eternal.EternalDataSnapshot;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PlayerSnapshotMessage;
import iskallia.vault.snapshot.AttributeSnapshot;
import iskallia.vault.snapshot.AttributeSnapshotCalculator;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.world.data.EternalsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.ObjectUtils;

public class AttributeSnapshotHelper {
    private static final AttributeSnapshotHelper instance = new AttributeSnapshotHelper();
    private final Map<UUID, AttributeSnapshot> playerSnapshots = new HashMap<UUID, AttributeSnapshot>();
    private final Set<UUID> scheduledSnapshotRefreshes = new HashSet<UUID>();
    private AttributeSnapshot clientPlayerSnapshot = null;

    private AttributeSnapshotHelper() {
    }

    public static AttributeSnapshotHelper getInstance() {
        return instance;
    }

    public static boolean canHaveSnapshot(LivingEntity entity) {
        return entity instanceof EternalEntity || entity instanceof Player;
    }

    @Nonnull
    public AttributeSnapshot getSnapshot(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.getOrCreatePlayerSnapshot(player);
        }
        if (entity instanceof EternalEntity) {
            EternalEntity eternal = (EternalEntity)entity;
            Level level = eternal.m_183503_();
            if (level instanceof ServerLevel) {
                ServerLevel sWorld = (ServerLevel)level;
                EternalData eternalData = EternalsData.get(sWorld).getEternal(eternal.getEternalId());
                if (eternalData != null) {
                    return eternalData.getAttributeSnapshot();
                }
            } else {
                EternalDataSnapshot snapshot = ClientEternalData.getSnapshot(eternal.getEternalId());
                if (snapshot != null) {
                    return snapshot.getAttributeSnapshot();
                }
            }
        }
        return AttributeSnapshot.EMPTY;
    }

    @Nonnull
    private AttributeSnapshot getOrCreatePlayerSnapshot(Player player) {
        if (player.m_20193_().m_5776_() || !(player instanceof ServerPlayer)) {
            return (AttributeSnapshot)ObjectUtils.firstNonNull((Object[])new AttributeSnapshot[]{this.clientPlayerSnapshot, AttributeSnapshot.EMPTY});
        }
        AttributeSnapshot snapshot = this.playerSnapshots.get(player.m_142081_());
        if (snapshot != null) {
            return snapshot;
        }
        return this.createAndCacheSnapshot((ServerPlayer)player);
    }

    public void refreshSnapshotDelayed(ServerPlayer player) {
        if (this.scheduledSnapshotRefreshes.add(player.m_142081_())) {
            ServerScheduler.INSTANCE.schedule(1, () -> {
                if (this.scheduledSnapshotRefreshes.remove(player.m_142081_())) {
                    this.refreshSnapshot(player);
                }
            });
        }
    }

    public void refreshSnapshot(ServerPlayer player) {
        this.playerSnapshots.remove(player.m_142081_());
        this.createAndCacheSnapshot(player);
    }

    @Nonnull
    public AttributeSnapshot makeGearSnapshot(Function<EquipmentSlot, ItemStack> equipmentFn) {
        AttributeSnapshot snapshot = new AttributeSnapshot();
        AttributeSnapshotCalculator.computeGearSnapshot(equipmentFn, item -> false, Integer.MAX_VALUE, snapshot);
        return snapshot;
    }

    @Nonnull
    private AttributeSnapshot createAndCacheSnapshot(ServerPlayer player) {
        AttributeSnapshot snapshot = new AttributeSnapshot();
        AttributeSnapshotCalculator.computeSnapshot(player, snapshot);
        this.playerSnapshots.put(player.m_142081_(), snapshot);
        PlayerSnapshotMessage msg = PlayerSnapshotMessage.of(snapshot);
        ModNetwork.CHANNEL.sendTo((Object)msg, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
        return snapshot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveClientSnapshot(AttributeSnapshot snapshot) {
        this.clientPlayerSnapshot = snapshot;
    }
}

