/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.snapshot;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.event.event.VaultGearEquipmentChangeEvent;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AttributeSnapshotNotifier {
    private static final Map<UUID, PlayerGearSnapshot> gearSnapshots = new HashMap<UUID, PlayerGearSnapshot>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        boolean snapshotRefresh = false;
        UUID playerId = sPlayer.m_142081_();
        PlayerGearSnapshot snapshot = gearSnapshots.computeIfAbsent(playerId, id -> new PlayerGearSnapshot());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            UUID savedId = snapshot.gearIdentifiers.get(slot);
            ItemStack equipment = event.player.m_6844_(slot);
            if (equipment.m_41619_() || !AttributeGearData.hasData(equipment)) {
                if (savedId == null) continue;
                AttributeSnapshotNotifier.gearChanged(sPlayer, slot);
                snapshotRefresh = true;
                snapshot.gearIdentifiers.remove(slot);
                continue;
            }
            UUID equipmentId = AttributeGearData.readUUID(equipment).orElseThrow();
            if (savedId == null) {
                AttributeSnapshotNotifier.gearChanged(sPlayer, slot);
                snapshotRefresh = true;
                snapshot.gearIdentifiers.put(slot, equipmentId);
                continue;
            }
            if (savedId.equals(equipmentId)) continue;
            AttributeSnapshotNotifier.gearChanged(sPlayer, slot);
            snapshotRefresh = true;
            snapshot.gearIdentifiers.put(slot, equipmentId);
        }
        for (Map.Entry entry : IntegrationCurios.getCuriosItemStacks((LivingEntity)sPlayer).entrySet()) {
            String slotIdentifier = (String)entry.getKey();
            List stackTuples = (List)entry.getValue();
            for (int slot = 0; slot < stackTuples.size(); ++slot) {
                ItemStack equipped = (ItemStack)((Tuple)stackTuples.get(slot)).m_14418_();
                CurioSlot curioSlot = new CurioSlot(slotIdentifier, slot);
                UUID savedId = snapshot.curioIdentifiers.get(curioSlot);
                if (equipped.m_41619_() || !AttributeGearData.hasData(equipped)) {
                    if (savedId == null) continue;
                    AttributeSnapshotNotifier.curioChanged(sPlayer, curioSlot);
                    snapshotRefresh = true;
                    snapshot.curioIdentifiers.remove(curioSlot);
                    continue;
                }
                UUID equipmentId = AttributeGearData.readUUID(equipped).orElseThrow();
                if (savedId == null) {
                    AttributeSnapshotNotifier.curioChanged(sPlayer, curioSlot);
                    snapshotRefresh = true;
                    snapshot.curioIdentifiers.put(curioSlot, equipmentId);
                    continue;
                }
                if (savedId.equals(equipmentId)) continue;
                AttributeSnapshotNotifier.curioChanged(sPlayer, curioSlot);
                snapshotRefresh = true;
                snapshot.curioIdentifiers.put(curioSlot, equipmentId);
            }
        }
        if (snapshotRefresh) {
            AttributeSnapshotHelper.getInstance().refreshSnapshot(sPlayer);
        }
    }

    private static void gearChanged(ServerPlayer player, EquipmentSlot slot) {
        MinecraftForge.EVENT_BUS.post((Event)new VaultGearEquipmentChangeEvent.Gear(player, slot));
    }

    private static void curioChanged(ServerPlayer player, CurioSlot slot) {
        MinecraftForge.EVENT_BUS.post((Event)new VaultGearEquipmentChangeEvent.Curio(player, slot.slotIdentifier(), slot.slotId()));
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CommonEvents.PLAYER_EQUIPMENT_SWAP.invoke(player, event.getFrom(), event.getTo(), event.getSlot());
    }

    private static class PlayerGearSnapshot {
        private final Map<EquipmentSlot, UUID> gearIdentifiers = new HashMap<EquipmentSlot, UUID>();
        private final Map<CurioSlot, UUID> curioIdentifiers = new HashMap<CurioSlot, UUID>();

        private PlayerGearSnapshot() {
        }
    }

    private record CurioSlot(String slotIdentifier, int slotId) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurioSlot curioSlot = (CurioSlot)o;
            return this.slotId == curioSlot.slotId && Objects.equals(this.slotIdentifier, curioSlot.slotIdentifier);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.slotIdentifier, this.slotId);
        }
    }
}

