/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundToastMessage;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ConsumableTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class AchievementCompleteTask
extends ConsumableTask<Config> {
    public AchievementCompleteTask() {
        this(new Config());
    }

    public AchievementCompleteTask(Config config) {
        super(config);
    }

    @Override
    protected void onConsume(TaskContext context) {
        TaskSource taskSource = context.getSource();
        if (!(taskSource instanceof EntityTaskSource)) {
            return;
        }
        EntityTaskSource entityTaskSource = (EntityTaskSource)taskSource;
        for (ServerPlayer player : entityTaskSource.getEntities(ServerPlayer.class)) {
            ModNetwork.CHANNEL.sendTo((Object)new ClientboundToastMessage(((Config)this.getConfig()).title, "Achievement Complete!", ((Config)this.getConfig()).icon), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            FireworkRocketEntity firework = new FireworkRocketEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Items.f_42688_));
            player.f_19853_.m_7967_((Entity)firework);
            String message = ((Config)this.getConfig()).message.replace("${player}", player.m_5446_().getString()).replace("${title}", ((Config)this.getConfig()).title);
            ServerLifecycleHooks.getCurrentServer().m_6846_().m_11264_((Component)new TextComponent(message).m_130940_(ChatFormatting.GREEN), ChatType.CHAT, Util.f_137441_);
        }
    }

    public static class Config
    extends ConfiguredTask.Config {
        private String title;
        private String message;
        private ResourceLocation icon;

        public Config() {
        }

        public Config(String title, String message, ResourceLocation icon) {
            this.title = title;
            this.message = message;
            this.icon = icon;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.UTF_8.writeBits(this.title, buffer);
            Adapters.UTF_8.writeBits(this.message, buffer);
            Adapters.IDENTIFIER.writeBits(this.icon, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.title = Adapters.UTF_8.readBits(buffer).orElseThrow();
            this.message = Adapters.UTF_8.readBits(buffer).orElseThrow();
            this.icon = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.UTF_8.writeNbt(this.title).ifPresent(value -> nbt.m_128365_("title", value));
                Adapters.UTF_8.writeNbt(this.message).ifPresent(value -> nbt.m_128365_("message", value));
                Adapters.IDENTIFIER.writeNbt(this.icon).ifPresent(value -> nbt.m_128365_("icon", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.title = Adapters.UTF_8.readNbt(nbt.m_128423_("title")).orElse("");
            this.message = Adapters.UTF_8.readNbt(nbt.m_128423_("message")).orElse("");
            this.icon = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("icon")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.UTF_8.writeJson(this.title).ifPresent(value -> json.add("title", value));
                Adapters.UTF_8.writeJson(this.message).ifPresent(value -> json.add("message", value));
                Adapters.IDENTIFIER.writeJson(this.icon).ifPresent(value -> json.add("icon", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.title = Adapters.UTF_8.readJson(json.get("title")).orElse("");
            this.message = Adapters.UTF_8.readJson(json.get("message")).orElse("");
            this.icon = Adapters.IDENTIFIER.readJson(json.get("icon")).orElse(VaultMod.id("empty"));
        }
    }
}

