/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.modifier.registry.VaultModifierRegistry;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ConsumableTask;
import iskallia.vault.task.TaskContext;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class AddVaultModifierTask
extends ConsumableTask<Config> {
    public AddVaultModifierTask() {
        super(new Config());
    }

    public AddVaultModifierTask(Config config) {
        super(config);
    }

    @Override
    protected void onConsume(TaskContext context) {
        if (context.getVault() == null) {
            return;
        }
        ArrayList modifiers = new ArrayList();
        ((Config)this.getConfig()).modifiers.forEach((id, count) -> {
            if (id.charAt(0) == '@') {
                ResourceLocation pool = ResourceLocation.m_135820_((String)id.substring(1));
                for (int i = 0; i < count; ++i) {
                    modifiers.addAll(ModConfigs.VAULT_MODIFIER_POOLS.getRandom(pool, context.getLevel(), context.getSource().getRandom()));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    VaultModifierRegistry.getOpt(ResourceLocation.m_135820_((String)id)).ifPresent(modifiers::add);
                }
            }
        });
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> AddVaultModifierTask.lambda$onConsume$1((Object2IntMap)groups, arg_0));
        ObjectIterator it = groups.object2IntEntrySet().iterator();
        groups.forEach((modifier, count) -> context.getVault().get(Vault.MODIFIERS).addModifier((VaultModifier<?>)modifier, (int)count, true, context.getSource().getRandom()));
        if (((Config)this.getConfig()).message == null || groups.isEmpty()) {
            return;
        }
        TextComponent modifierNames = new TextComponent("");
        while (it.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it.next();
            modifierNames.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it.hasNext()) continue;
            modifierNames.m_7220_((Component)new TextComponent(", "));
        }
        Component message = this.replace(((Config)this.getConfig()).message, "${modifiers}", (Component)modifierNames);
        for (Listener listener : context.getVault().get(Vault.LISTENERS).getAll()) {
            listener.getPlayer().ifPresent(player -> {
                player.m_5661_(message, false);
                player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_12211_, SoundSource.MASTER, 1.0f, 0.75f + player.f_19853_.m_5822_().nextFloat() * 0.25f);
            });
        }
    }

    public Component replace(Component component, String target, Component replacement) {
        if (!(component instanceof TextComponent)) {
            return component;
        }
        TextComponent base = (TextComponent)component;
        List siblings = base.m_7360_();
        siblings.add(0, base.m_6879_().m_6270_(base.m_7383_()));
        for (int i = 0; i < siblings.size(); ++i) {
            String text;
            Component sibling = (Component)siblings.get(i);
            if (!(sibling instanceof TextComponent) || (text = ((TextComponent)sibling).m_131292_()).isEmpty()) continue;
            ArrayList<Object> parts = new ArrayList<Object>();
            if (text.equals(target)) {
                parts.add(replacement);
            } else {
                for (String raw : text.split(Pattern.quote(target))) {
                    parts.add(new TextComponent(raw).m_6270_(sibling.m_7383_()));
                    parts.add(replacement);
                }
                parts.remove(parts.size() - 1);
            }
            siblings.remove(i);
            for (int j = 0; j < parts.size(); ++j) {
                siblings.add(i, (Component)parts.get(parts.size() - j - 1));
            }
        }
        TextComponent result = new TextComponent("");
        result.m_6270_(base.m_7383_());
        for (Component sibling : siblings) {
            result.m_7220_(sibling);
        }
        return result;
    }

    private static /* synthetic */ void lambda$onConsume$1(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }

    public static class Config
    extends ConfiguredTask.Config {
        public Map<String, Integer> modifiers;
        public Component message;

        public Config() {
            this.modifiers = new LinkedHashMap<String, Integer>();
        }

        public Config(Map<String, Integer> modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.modifiers.size(), buffer);
            this.modifiers.forEach((id, count) -> {
                Adapters.UTF_8.writeBits((String)id, buffer);
                Adapters.INT_SEGMENTED_3.writeBits(count, buffer);
            });
            Adapters.COMPONENT.writeBits(this.message, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            this.modifiers.clear();
            for (int i = 0; i < size; ++i) {
                this.modifiers.put(Adapters.UTF_8.readBits(buffer).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow());
            }
            this.message = Adapters.COMPONENT.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                CompoundTag modifiers = new CompoundTag();
                this.modifiers.forEach((id, count) -> Adapters.INT.writeNbt(count).ifPresent(tag -> modifiers.m_128365_("id", tag)));
                nbt.m_128365_("modifiers", (Tag)modifiers);
                Adapters.COMPONENT.writeNbt(this.message).ifPresent(tag -> nbt.m_128365_("message", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.modifiers.clear();
            Tag tag = nbt.m_128423_("modifiers");
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                for (String key : compound.m_128431_()) {
                    Adapters.INT.readNbt(compound.m_128423_(key)).ifPresent(count -> this.modifiers.put(key, (Integer)count));
                }
            }
            this.message = Adapters.COMPONENT.readNbt(nbt.m_128423_("message")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                JsonObject modifiers = new JsonObject();
                this.modifiers.forEach((id, count) -> Adapters.INT.writeJson(count).ifPresent(tag -> modifiers.add("id", tag)));
                modifiers.add("modifiers", (JsonElement)modifiers);
                Adapters.COMPONENT.writeJson(this.message).ifPresent(tag -> json.add("message", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.modifiers.clear();
            JsonElement jsonElement = json.get("modifiers");
            if (jsonElement instanceof JsonObject) {
                JsonObject object = (JsonObject)jsonElement;
                for (String key : object.keySet()) {
                    Adapters.INT.readJson(object.get(key)).ifPresent(count -> this.modifiers.put(key, (Integer)count));
                }
            }
            this.message = Adapters.COMPONENT.readJson(json.get("message")).orElse(null);
        }
    }
}

