/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.BingoObjective;
import iskallia.vault.task.BingoTask;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.List;
import java.util.UUID;

public class BingoObjectiveTask
extends ProgressConfiguredTask<Integer, Config> {
    public BingoObjectiveTask() {
        super(new Config(), TaskCounter.Adapter.INT);
    }

    public BingoObjectiveTask(TaskCounter<Integer, ?> counter) {
        super(new Config(), counter, TaskCounter.Adapter.INT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.register(this, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            if (context.getVault() == null) {
                return;
            }
            List<BingoObjective> bingoObjectives = context.getVault().get(Vault.OBJECTIVES).getAll(BingoObjective.class);
            bingoObjectives.forEach(bingoObjective -> {
                TaskSource patt1351$temp;
                int bingos = bingoObjective.getBingos();
                if (!bingoObjective.get(BingoObjective.TASKS).isEmpty() && (patt1351$temp = context.getSource()) instanceof EntityTaskSource) {
                    EntityTaskSource source = (EntityTaskSource)patt1351$temp;
                    UUID uuid = source.getUuids().stream().findFirst().orElse(null);
                    if (uuid != null) {
                        Task t = (Task)bingoObjective.get(BingoObjective.TASKS).get(uuid);
                        if (t instanceof BingoTask) {
                            BingoTask board = (BingoTask)t;
                            bingos = board.getCompletedBingos();
                        } else {
                            bingos = 0;
                        }
                    } else {
                        bingos = 0;
                    }
                }
                this.counter.onSet(bingos, context);
            });
        });
        super.onAttach(context);
    }

    public static class Config
    extends ConfiguredTask.Config {
    }
}

