/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultUtils;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.renderer.BingoRenderer;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.source.EntityTaskSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class BingoTask
extends ConfiguredTask<Config>
implements LevelEntryList.ILevelEntry {
    private Task[] tasks;
    private boolean[] settledTasks;
    private boolean[] settledBingos;
    private List<Task> rewards = new ArrayList<Task>();
    private Map<UUID, Integer> selectedBingoIndex = new HashMap<UUID, Integer>();
    private static final ArrayAdapter<Task> CHILDREN = Adapters.ofArray(Task[]::new, Adapters.TASK);

    public BingoTask() {
        super(new Config());
    }

    public BingoTask(Config config) {
        super(config);
    }

    @Override
    public int getLevel() {
        return ((Config)this.getConfig()).level;
    }

    public int getWidth() {
        return ((Config)this.getConfig()).width;
    }

    public int getHeight() {
        return ((Config)this.getConfig()).height;
    }

    public int getIndex(int row, int column) {
        return row * this.getWidth() + column;
    }

    public Task getChild(int index) {
        return this.tasks[index];
    }

    public Task getChild(int row, int column) {
        return this.getChild(this.getIndex(row, column));
    }

    public void setChild(int index, NodeTask task) {
        this.tasks[index] = task;
    }

    public void setChild(int row, int column, NodeTask task) {
        this.setChild(this.getIndex(row, column), task);
    }

    public State getState(int index) {
        return this.getState(index / this.getWidth(), index % this.getWidth());
    }

    public State getState(int row, int column) {
        if (!this.isCompleted(row, column)) {
            return State.INCOMPLETE;
        }
        if (this.isBingo(row)) {
            return State.BINGO;
        }
        if (this.isBingo(this.getHeight() + column)) {
            return State.BINGO;
        }
        if (this.getWidth() == this.getHeight()) {
            if (row == column && this.isBingo(this.getWidth() + this.getHeight())) {
                return State.BINGO;
            }
            if (this.getHeight() - row - 1 == column && this.isBingo(this.getWidth() + this.getHeight() + 1)) {
                return State.BINGO;
            }
        }
        return State.COMPLETE;
    }

    public boolean isCompleted(int index) {
        return this.settledTasks[index];
    }

    public boolean isCompleted(int row, int column) {
        return this.isCompleted(this.getIndex(row, column));
    }

    public boolean areAllCompleted() {
        for (int row = 0; row < ((Config)this.getConfig()).height; ++row) {
            for (int column = 0; column < ((Config)this.getConfig()).width; ++column) {
                if (this.isCompleted(row, column)) continue;
                return false;
            }
        }
        for (Task reward : this.rewards) {
            if (reward.isCompleted()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<Task> getChildren() {
        return Iterables.concat(Arrays.asList(this.tasks), this.rewards);
    }

    @Override
    public void onPopulate(TaskContext context) {
        this.tasks = new NodeTask[this.getWidth() * this.getHeight()];
        WeightedList<Task> pool = ((Config)this.getConfig()).getTasks(context);
        pool.keySet().forEach(task -> task.getSelfAndChildren().forEach(subTask -> {
            if (subTask instanceof ProgressConfiguredTask) {
                ProgressConfiguredTask progressTask = (ProgressConfiguredTask)subTask;
                progressTask.getCounter().populate(context);
            }
        }));
        pool.keySet().removeIf(task -> {
            ProgressConfiguredTask progressTask;
            return task instanceof ProgressConfiguredTask && (progressTask = (ProgressConfiguredTask)task).getCondition() != null && !progressTask.getCondition().isConditionFulfilled(progressTask, context);
        });
        int count = this.getWidth() * this.getHeight();
        ArrayList<Object> tasks = new ArrayList<Object>();
        while (tasks.size() < count) {
            if (tasks.size() + pool.size() < count) {
                tasks.addAll(pool.keySet());
                continue;
            }
            pool.getRandom(context.getSource().getRandom()).ifPresent(key -> {
                tasks.add(key);
                pool.remove(key);
            });
        }
        for (int i = tasks.size() - 1; i > 0; --i) {
            tasks.set(i, tasks.set(context.getSource().getRandom().nextInt(i + 1), (Task)tasks.get(i)));
        }
        for (int index = 0; index < count; ++index) {
            this.setChild(index, (NodeTask)((Task)tasks.get(index)).copy());
        }
        this.settledTasks = new boolean[this.tasks.length];
        this.settledBingos = new boolean[this.getMaxBingos()];
        this.rewards = new ArrayList<Task>();
    }

    @Override
    public void onTick(TaskContext context) {
        super.onTick(context);
        for (int index = 0; index < this.getWidth() * this.getHeight(); ++index) {
            boolean completed = this.getChild(index).streamSelfAndDescendants().allMatch(Task::isCompleted);
            boolean settled = this.settledTasks[index];
            Task task = this.getChild(index);
            if (!completed || settled) continue;
            this.onComplete(task, context);
            this.settledTasks[index] = true;
            task.onDetach();
        }
        for (int lineIndex = 0; lineIndex < this.getMaxBingos(); ++lineIndex) {
            if (!this.isBingo(lineIndex) || this.settledBingos[lineIndex]) continue;
            this.onBingo(context);
            this.settledBingos[lineIndex] = true;
        }
    }

    private void onBingo(TaskContext context) {
        WeightedList<Task> pool = this.getCompletedBingos() == 0 ? ((Config)this.getConfig()).getFirstBingo(context) : ((Config)this.getConfig()).getSubsequentBingo(context);
        pool.getRandom(context.getSource().getRandom()).ifPresent(task -> {
            task = task.copy();
            this.rewards.add((Task)task);
            task.onAttach(context);
        });
    }

    @Override
    public void onAttach(TaskContext context) {
        super.onAttach(context);
        for (int index = 0; index < this.getWidth() * this.getHeight(); ++index) {
            boolean settled = this.settledTasks[index];
            if (!settled) continue;
            Task task = this.getChild(index);
            this.onComplete(task, context);
            task.onDetach();
        }
    }

    private void onComplete(Task task, TaskContext context) {
        Iterator<ServerPlayer> iterator;
        String name = task.streamSelfAndDescendants().flatMap(child -> {
            TaskRenderer patt7642$temp = child.getRenderer();
            if (patt7642$temp instanceof BingoRenderer.Leaf) {
                BingoRenderer.Leaf renderer = (BingoRenderer.Leaf)patt7642$temp;
                return Stream.of(renderer.name);
            }
            return Stream.empty();
        }).findFirst().orElse("Unknown");
        boolean pvp = VaultUtils.isPvPVault(context.getVault());
        if (pvp && (iterator = context.getSource()) instanceof EntityTaskSource) {
            EntityTaskSource entitySource = (EntityTaskSource)((Object)iterator);
            for (ServerPlayer player2 : entitySource.getEntities(context.getServer(), ServerPlayer.class)) {
                player2.m_5661_((Component)new TextComponent("").m_7220_((Component)new TextComponent("Completed ").m_130940_(ChatFormatting.GRAY)).m_130946_(name).m_7220_((Component)new TextComponent("!").m_130940_(ChatFormatting.GRAY)), false);
                player2.f_19853_.m_6269_(null, (Entity)player2, SoundEvents.f_12211_, SoundSource.MASTER, 0.75f, 0.75f + player2.f_19853_.m_5822_().nextFloat() * 0.25f);
            }
        } else {
            for (Listener listener : context.getVault().get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(player -> {
                    player.m_5661_((Component)new TextComponent("").m_7220_((Component)new TextComponent("Completed ").m_130940_(ChatFormatting.GRAY)).m_130946_(name).m_7220_((Component)new TextComponent("!").m_130940_(ChatFormatting.GRAY)), false);
                    player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_12211_, SoundSource.MASTER, 0.75f, 0.75f + player.f_19853_.m_5822_().nextFloat() * 0.25f);
                });
            }
        }
    }

    public int getCompletedBingos() {
        int count = 0;
        for (boolean value : this.settledBingos) {
            count += value ? 1 : 0;
        }
        return count;
    }

    public int getMaxBingos() {
        return this.getHeight() + this.getWidth() + (this.getWidth() == this.getHeight() ? 2 : 0);
    }

    public boolean isBingo(int lineIndex) {
        for (int index : this.getLine(lineIndex)) {
            if (this.isCompleted(index)) continue;
            return false;
        }
        return true;
    }

    public int[] getSelectedLine(UUID uuid) {
        return this.getLine(this.selectedBingoIndex.getOrDefault(uuid, 0));
    }

    public int[] getLine(int lineIndex) {
        if (lineIndex < this.getHeight()) {
            int[] bingo = new int[this.getWidth()];
            for (int column = 0; column < this.getWidth(); ++column) {
                bingo[column] = this.getIndex(lineIndex, column);
            }
            return bingo;
        }
        if ((lineIndex -= this.getHeight()) < this.getWidth()) {
            int[] bingo = new int[this.getHeight()];
            for (int row = 0; row < this.getHeight(); ++row) {
                bingo[row] = this.getIndex(row, lineIndex);
            }
            return bingo;
        }
        if (this.getWidth() == this.getHeight() && (lineIndex -= this.getWidth()) < 2) {
            int[] bingo = new int[this.getWidth()];
            for (int index = 0; index < this.getWidth(); ++index) {
                if (lineIndex == 0) {
                    bingo[index] = this.getIndex(index, index);
                    continue;
                }
                if (lineIndex != 1) continue;
                bingo[index] = this.getIndex(this.getHeight() - index - 1, index);
            }
            return bingo;
        }
        throw new UnsupportedOperationException();
    }

    public void progressBingoLine(UUID uuid, int delta) {
        this.selectedBingoIndex.put(uuid, Math.floorMod(this.selectedBingoIndex.getOrDefault(uuid, 0) + delta, this.getMaxBingos()));
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        CHILDREN.writeBits((Task)this.tasks, buffer);
        Adapters.BOOLEAN_ARRAY.writeBits(this.settledTasks, buffer);
        Adapters.BOOLEAN_ARRAY.writeBits(this.settledBingos, buffer);
        CHILDREN.writeBits((Task)((Task[])this.rewards.toArray(Task[]::new)), buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.selectedBingoIndex.size(), buffer);
        this.selectedBingoIndex.forEach((uuid, index) -> {
            Adapters.UUID.writeBits((UUID)uuid, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(index, buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.tasks = (Task[])CHILDREN.readBits(buffer).orElseThrow();
        this.settledTasks = Adapters.BOOLEAN_ARRAY.readBits(buffer).orElseThrow();
        this.settledBingos = Adapters.BOOLEAN_ARRAY.readBits(buffer).orElseThrow();
        this.rewards.clear();
        this.rewards.addAll(Arrays.asList(CHILDREN.readBits(buffer).orElse(new Task[0])));
        this.selectedBingoIndex.clear();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        for (int i = 0; i < size; ++i) {
            this.selectedBingoIndex.put(Adapters.UUID.readBits(buffer).orElseThrow(), (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow());
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            CHILDREN.writeNbt((Task)this.tasks).ifPresent(value -> nbt.m_128365_("tasks", value));
            Adapters.BOOLEAN_ARRAY.writeNbt(this.settledTasks).ifPresent(value -> nbt.m_128365_("settledTasks", value));
            Adapters.BOOLEAN_ARRAY.writeNbt(this.settledBingos).ifPresent(value -> nbt.m_128365_("settledBingos", value));
            CHILDREN.writeNbt((Task)((Task[])this.rewards.toArray(Task[]::new))).ifPresent(value -> nbt.m_128365_("rewards", value));
            CompoundTag selectedBingoIndex = new CompoundTag();
            this.selectedBingoIndex.forEach((uuid, index) -> Adapters.INT.writeNbt(index).ifPresent(tag -> selectedBingoIndex.m_128365_(uuid.toString(), tag)));
            nbt.m_128365_("selectedBingoIndex", (Tag)selectedBingoIndex);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.tasks = CHILDREN.readNbt(nbt.m_128423_("tasks")).orElse(new Task[0]);
        this.settledTasks = Adapters.BOOLEAN_ARRAY.readNbt(nbt.m_128423_("settledTasks")).orElse(new boolean[0]);
        this.settledBingos = Adapters.BOOLEAN_ARRAY.readNbt(nbt.m_128423_("settledBingos")).orElse(new boolean[0]);
        Arrays.stream(this.tasks).forEach(child -> {
            child.parent = this;
        });
        this.rewards.clear();
        this.rewards.addAll(Arrays.asList(CHILDREN.readNbt(nbt.m_128423_("rewards")).orElse(new Task[0])));
        this.rewards.forEach(child -> {
            child.parent = this;
        });
        this.selectedBingoIndex.clear();
        CompoundTag selectedBingoIndex = nbt.m_128469_("selectedBingoIndex");
        for (String key : selectedBingoIndex.m_128431_()) {
            Adapters.INT.readNbt(selectedBingoIndex.m_128423_(key)).ifPresent(index -> this.selectedBingoIndex.put(UUID.fromString(key), (Integer)index));
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            CHILDREN.writeJson((Task)this.tasks).ifPresent(value -> json.add("tasks", value));
            CHILDREN.writeJson((Task)((Task[])this.rewards.toArray(Task[]::new))).ifPresent(value -> json.add("rewards", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.tasks = CHILDREN.readJson(json.get("tasks")).orElse(new Task[0]);
        Arrays.stream(this.tasks).forEach(child -> {
            child.parent = this;
        });
        this.rewards.addAll(Arrays.asList(CHILDREN.readJson(json.get("rewards")).orElse(new Task[0])));
        this.rewards.forEach(child -> {
            child.parent = this;
        });
    }

    public static class Config
    extends ConfiguredTask.Config {
        private int level;
        private int width;
        private int height;
        private final Map<Integer, WeightedList<Task>> tasks;
        private final Map<Integer, WeightedList<Task>> firstBingo;
        private final Map<Integer, WeightedList<Task>> subsequentBingo;

        public Config() {
            this.tasks = new HashMap<Integer, WeightedList<Task>>();
            this.firstBingo = new HashMap<Integer, WeightedList<Task>>();
            this.subsequentBingo = new HashMap<Integer, WeightedList<Task>>();
        }

        public Config(int width, int height) {
            this.width = width;
            this.height = height;
            this.tasks = new HashMap<Integer, WeightedList<Task>>();
            this.firstBingo = new HashMap<Integer, WeightedList<Task>>();
            this.subsequentBingo = new HashMap<Integer, WeightedList<Task>>();
        }

        private WeightedList<Task> getTasks(TaskContext context) {
            return this.getPool(this.tasks, context);
        }

        private WeightedList<Task> getFirstBingo(TaskContext context) {
            return this.getPool(this.firstBingo, context);
        }

        private WeightedList<Task> getSubsequentBingo(TaskContext context) {
            return this.getPool(this.subsequentBingo, context);
        }

        private WeightedList<Task> getPool(Map<Integer, WeightedList<Task>> map, TaskContext context) {
            WeightedList<Task> result = new WeightedList<Task>();
            map.forEach((level, pool) -> {
                if (level <= context.getLevel()) {
                    result.putAll(pool);
                }
            });
            return result;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.level, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.width, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.height, buffer);
            Stream.of(this.tasks, this.firstBingo, this.subsequentBingo).forEach(map -> {
                Adapters.INT_SEGMENTED_7.writeBits(map.size(), buffer);
                map.forEach((level, pool) -> {
                    Adapters.INT_SEGMENTED_7.writeBits(level, buffer);
                    Adapters.INT_SEGMENTED_7.writeBits(pool.size(), buffer);
                    pool.forEach((task, weight) -> {
                        Adapters.TASK.writeBits(task, buffer);
                        Adapters.DOUBLE.writeBits(weight, buffer);
                    });
                });
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.level = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            this.width = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            this.height = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            Stream.of(this.tasks, this.firstBingo, this.subsequentBingo).forEach(map -> {
                map.clear();
                int mapSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                for (int i = 0; i < mapSize; ++i) {
                    int level = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                    int poolSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                    WeightedList<Task> pool = new WeightedList<Task>();
                    for (int j = 0; j < poolSize; ++j) {
                        pool.add((Task)Adapters.TASK.readBits(buffer).orElseThrow(), (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow());
                    }
                    map.put(level, pool);
                }
            });
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.INT.writeNbt(this.level).ifPresent(tag -> nbt.m_128365_("level", tag));
                Adapters.INT.writeNbt(this.width).ifPresent(tag -> nbt.m_128365_("width", tag));
                Adapters.INT.writeNbt(this.height).ifPresent(tag -> nbt.m_128365_("height", tag));
                Stream.of(this.tasks, this.firstBingo, this.subsequentBingo).forEach(map -> {
                    ListTag list = new ListTag();
                    map.forEach((level, pool) -> pool.forEach((task, weight) -> Adapters.TASK.writeNbt(task).ifPresent(tag -> {
                        if (!(tag instanceof CompoundTag)) {
                            return;
                        }
                        CompoundTag compound = (CompoundTag)tag;
                        Adapters.INT.writeNbt(level).ifPresent(t -> compound.m_128365_("level", t));
                        Adapters.DOUBLE.writeNbt(weight).ifPresent(t -> compound.m_128365_("weight", t));
                        list.add(tag);
                    })));
                    nbt.m_128365_(map == this.tasks ? "tasks" : (map == this.firstBingo ? "firstBingo" : "subsequentBingo"), (Tag)list);
                });
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.level = (Integer)Adapters.INT.readNbt(nbt.m_128423_("level")).orElseThrow();
            this.width = (Integer)Adapters.INT.readNbt(nbt.m_128423_("width")).orElseThrow();
            this.height = (Integer)Adapters.INT.readNbt(nbt.m_128423_("height")).orElseThrow();
            Stream.of(this.tasks, this.firstBingo, this.subsequentBingo).forEach(map -> {
                map.clear();
                ListTag list = nbt.m_128437_(map == this.tasks ? "tasks" : (map == this.firstBingo ? "firstBingo" : "subsequentBingo"), 10);
                for (Tag element : list) {
                    if (!(element instanceof CompoundTag)) continue;
                    CompoundTag compound = (CompoundTag)element;
                    Adapters.TASK.readNbt(element).ifPresent(task -> {
                        int level = Adapters.INT.readNbt(compound.m_128423_("level")).orElse(0);
                        double weight = Adapters.DOUBLE.readNbt(compound.m_128423_("weight")).orElse(1.0);
                        map.computeIfAbsent(level, i -> new WeightedList()).add(task, weight);
                    });
                }
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.INT.writeJson(this.level).ifPresent(tag -> json.add("level", tag));
                Adapters.INT.writeJson(this.width).ifPresent(tag -> json.add("width", tag));
                Adapters.INT.writeJson(this.height).ifPresent(tag -> json.add("height", tag));
                Stream.of(this.tasks, this.firstBingo, this.subsequentBingo).forEach(map -> {
                    JsonArray list = new JsonArray();
                    map.forEach((level, pool) -> pool.forEach((task, weight) -> Adapters.TASK.writeJson(task).ifPresent(tag -> {
                        if (!(tag instanceof JsonObject)) {
                            return;
                        }
                        JsonObject object = (JsonObject)tag;
                        Adapters.INT.writeJson(level).ifPresent(t -> object.add("level", t));
                        Adapters.DOUBLE.writeJson(weight).ifPresent(t -> object.add("weight", t));
                        list.add(tag);
                    })));
                    json.add(map == this.tasks ? "tasks" : (map == this.firstBingo ? "firstBingo" : "subsequentBingo"), (JsonElement)list);
                });
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.level = (Integer)Adapters.INT.readJson(json.get("level")).orElseThrow();
            this.width = (Integer)Adapters.INT.readJson(json.get("width")).orElseThrow();
            this.height = (Integer)Adapters.INT.readJson(json.get("height")).orElseThrow();
            this.tasks.clear();
            Stream.of(this.tasks, this.firstBingo, this.subsequentBingo).forEach(map -> {
                map.clear();
                JsonArray list = json.getAsJsonArray(map == this.tasks ? "tasks" : (map == this.firstBingo ? "firstBingo" : "subsequentBingo"));
                if (list == null) {
                    return;
                }
                for (JsonElement element : list) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject object = (JsonObject)element;
                    Adapters.TASK.readJson(element).ifPresent(task -> {
                        int level = Adapters.INT.readJson(object.get("level")).orElse(0);
                        double weight = Adapters.DOUBLE.readJson(object.get("weight")).orElse(1.0);
                        map.computeIfAbsent(level, i -> new WeightedList()).add(task, weight);
                    });
                }
            });
        }
    }

    public static enum State {
        INCOMPLETE,
        COMPLETE,
        BINGO;

    }
}

