/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.block.ICollectionTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.event.common.BlockUseEvent;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.util.InventoryUtil;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CollectionTask
extends ProgressConfiguredTask<Integer, Config> {
    public CollectionTask() {
        super(new Config(), TaskCounter.Adapter.INT);
    }

    public CollectionTask(Config config, TaskCounter<Integer, ?> counter) {
        super(config, counter, TaskCounter.Adapter.INT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.BLOCK_USE.register(this, event -> {
            ICollectionTileEntity collectionTile;
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            if (event.getWorld().m_5776_()) {
                return;
            }
            TaskSource patt1345$temp = context.getSource();
            if (!(patt1345$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt1345$temp;
            if (!entitySource.matches((Entity)event.getPlayer())) {
                return;
            }
            BlockEntity tile = event.getWorld().m_7702_(event.getPos());
            if (!(tile instanceof ICollectionTileEntity) || !(collectionTile = (ICollectionTileEntity)tile).isForTask(this.id)) {
                return;
            }
            if (this.collectItems(context, (BlockUseEvent.Data)event)) {
                event.setResult(InteractionResult.SUCCESS);
            }
        });
        super.onAttach(context);
    }

    private boolean collectItems(TaskContext context, BlockUseEvent.Data event) {
        boolean collected = false;
        for (InventoryUtil.ItemAccess itemAccess : InventoryUtil.findAllItems(event.getPlayer())) {
            ItemStack stack;
            if (((Config)this.getConfig()).item != null && ((Config)this.getConfig()).item.test(stack = itemAccess.getStack())) {
                int remaining = this.counter.getProgress().getTarget().intValue() - this.counter.getProgress().getCurrent().intValue();
                if (remaining <= 0) break;
                int shrinkBy = Math.min(remaining, stack.m_41613_());
                this.counter.onAdd(shrinkBy, context);
                if (shrinkBy == stack.m_41613_()) {
                    itemAccess.setStack(ItemStack.f_41583_);
                } else {
                    stack.m_41774_(shrinkBy);
                    itemAccess.setStack(stack);
                }
                collected = true;
            }
            if (!this.counter.isCompleted()) continue;
            break;
        }
        return collected;
    }

    public static class Config
    extends ConfiguredTask.Config {
        public ItemPredicate item;

        public Config() {
        }

        public Config(ItemPredicate item) {
            this.item = item;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.ITEM_PREDICATE.writeBits(this.item, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.item = Adapters.ITEM_PREDICATE.readBits(buffer).orElse(null);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.ITEM_PREDICATE.writeNbt(this.item).ifPresent(value -> nbt.m_128365_("item", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.item = Adapters.ITEM_PREDICATE.readNbt(nbt.m_128423_("item")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.ITEM_PREDICATE.writeJson(this.item).ifPresent(value -> json.add("item", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.item = Adapters.ITEM_PREDICATE.readJson(json.get("item")).orElse(null);
        }
    }
}

