/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.OperableTask;
import iskallia.vault.task.ResettingTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ConfiguredTask<C extends Config>
extends OperableTask
implements ResettingTask {
    private C config;
    private boolean populated;

    public ConfiguredTask() {
    }

    protected ConfiguredTask(C config) {
        this.config = config;
    }

    public C getConfig() {
        return this.config;
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public abstract void onPopulate(TaskContext var1);

    @Override
    public boolean isCompleted() {
        return this.populated;
    }

    @Override
    public void onAttach(TaskContext context) {
        if (!this.populated) {
            this.onPopulate(context);
            this.populated = true;
        }
        super.onAttach(context);
    }

    @Override
    public void onReset(TaskContext context) {
        if (!this.populated) {
            this.onPopulate(context);
            this.populated = true;
        }
        for (Task child : this.getChildren()) {
            if (!(child instanceof ResettingTask)) continue;
            ResettingTask resettingTask = (ResettingTask)((Object)child);
            resettingTask.onReset(context);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        ((Config)this.config).writeBits(buffer);
        Adapters.BOOLEAN.writeBits(this.populated, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        ((Config)this.config).readBits(buffer);
        this.populated = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.populated) {
                CompoundTag other = ((Config)this.config).writeNbt().orElseThrow();
                other.m_128431_().forEach(key -> nbt.m_128365_(key, Objects.requireNonNull(other.m_128423_(key))));
            } else {
                nbt.m_128365_("config", (Tag)((Config)this.config).writeNbt().orElseThrow());
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!nbt.m_128441_("config")) {
            ((Config)this.config).readNbt(nbt);
            this.populated = false;
        } else {
            ((Config)this.config).readNbt(nbt.m_128469_("config"));
            this.populated = true;
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.populated) {
                ((Config)this.config).writeJson().orElseThrow().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            } else {
                json.add("config", (JsonElement)((Config)this.config).writeJson().orElseThrow());
            }
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!json.has("config")) {
            ((Config)this.config).readJson(json);
            this.populated = false;
        } else {
            ((Config)this.config).readJson(json.getAsJsonObject("config"));
            this.populated = true;
        }
    }

    public static abstract class Config
    implements ISerializable<CompoundTag, JsonObject> {
        @Override
        public void writeBits(BitBuffer buffer) {
        }

        @Override
        public void readBits(BitBuffer buffer) {
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag());
        }

        @Override
        public void readNbt(CompoundTag nbt) {
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject());
        }

        @Override
        public void readJson(JsonObject json) {
        }
    }
}

