/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.EventPriority;

public class CraftingTask
extends ProgressConfiguredTask<Integer, Config> {
    public CraftingTask() {
        super(new Config(), TaskCounter.Adapter.INT);
    }

    public CraftingTask(Config config, TaskCounter<Integer, ?> counter) {
        super(config, counter, TaskCounter.Adapter.INT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.PLAYER_CRAFT.register((Object)this, EventPriority.NORMAL, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            TaskSource patt1061$temp = context.getSource();
            if (!(patt1061$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt1061$temp;
            if (!entitySource.matches((Entity)event.getPlayer())) {
                return;
            }
            if (!((Config)this.getConfig()).filter.test(event.getCrafting())) {
                return;
            }
            this.counter.onAdd(1, context);
        });
        super.onAttach(context);
    }

    public static class Config
    extends ConfiguredTask.Config {
        public ItemPredicate filter;

        public Config() {
        }

        public Config(ItemPredicate filter) {
            this.filter = filter;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.ITEM_PREDICATE.writeBits(this.filter, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.filter = Adapters.ITEM_PREDICATE.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.ITEM_PREDICATE.writeNbt(this.filter).ifPresent(value -> nbt.m_128365_("filter", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.filter = Adapters.ITEM_PREDICATE.readNbt(nbt.m_128423_("filter")).orElseThrow();
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.ITEM_PREDICATE.writeJson(this.filter).ifPresent(value -> json.add("filter", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.filter = Adapters.ITEM_PREDICATE.readJson(json.get("filter")).orElseThrow();
        }
    }
}

