/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.task.util.DamagePhase;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.EventPriority;

public class DealDamageTask
extends ProgressConfiguredTask<Float, Config> {
    public DealDamageTask() {
        super(new Config(), TaskCounter.Adapter.FLOAT);
    }

    public DealDamageTask(Config config, TaskCounter<Float, ?> counter) {
        super(config, counter, TaskCounter.Adapter.FLOAT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.ENTITY_HURT.register((Object)this, EventPriority.HIGHEST, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            if (((Config)this.getConfig()).phase != DamagePhase.PRE_MITIGATION) {
                return;
            }
            this.onDealDamage(context, event.getSource().m_7639_(), event.getEntity(), event.getAmount());
        });
        CommonEvents.ENTITY_DAMAGE.register((Object)this, EventPriority.HIGHEST, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            if (((Config)this.getConfig()).phase != DamagePhase.POST_MITIGATION) {
                return;
            }
            this.onDealDamage(context, event.getSource().m_7639_(), event.getEntity(), event.getAmount());
        });
        super.onAttach(context);
    }

    public void onDealDamage(TaskContext context, Entity attacker, Entity attacked, float amount) {
        TaskSource taskSource = context.getSource();
        if (!(taskSource instanceof EntityTaskSource)) {
            return;
        }
        EntityTaskSource source = (EntityTaskSource)taskSource;
        if (attacked == null || attacker == null || attacked.m_183503_().m_5776_()) {
            return;
        }
        if (attacker.m_183503_() != attacked.m_183503_()) {
            return;
        }
        if (!source.matches(attacker)) {
            return;
        }
        if (!((Config)this.getConfig()).filter.test(attacked)) {
            return;
        }
        this.counter.onAdd(Float.valueOf(amount), context);
    }

    public static class Config
    extends ConfiguredTask.Config {
        public static final EnumAdapter<DamagePhase> PHASE = Adapters.ofEnum(DamagePhase.class, EnumAdapter.Mode.NAME);
        public EntityPredicate filter;
        public DamagePhase phase;

        public Config() {
        }

        public Config(EntityPredicate filter, DamagePhase phase) {
            this.filter = filter;
            this.phase = phase;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.ENTITY_PREDICATE.writeBits(this.filter, buffer);
            PHASE.writeBits(this.phase, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.filter = Adapters.ENTITY_PREDICATE.readBits(buffer).orElseThrow();
            this.phase = PHASE.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.ENTITY_PREDICATE.writeNbt(this.filter).ifPresent(value -> nbt.m_128365_("filter", value));
                PHASE.writeNbt(this.phase).ifPresent(value -> nbt.m_128365_("phase", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.filter = Adapters.ENTITY_PREDICATE.readNbt(nbt.m_128423_("filter")).orElse(EntityPredicate.FALSE);
            this.phase = PHASE.readNbt(nbt.m_128423_("phase")).orElseThrow();
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.ENTITY_PREDICATE.writeJson(this.filter).ifPresent(value -> json.add("filter", value));
                PHASE.writeJson(this.phase).ifPresent(value -> json.add("phase", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.filter = Adapters.ENTITY_PREDICATE.readJson(json.get("filter")).orElse(EntityPredicate.FALSE);
            this.phase = PHASE.readJson(json.get("phase")).orElseThrow();
        }
    }
}

