/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.random.ChunkRandom;
import iskallia.vault.core.util.RegionPos;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.WorldManager;
import iskallia.vault.core.world.generator.GridGenerator;
import iskallia.vault.core.world.generator.VaultGenerator;
import iskallia.vault.core.world.generator.layout.GridLayout;
import iskallia.vault.core.world.generator.layout.VaultGridLayout;
import iskallia.vault.core.world.generator.layout.VaultLayout;
import iskallia.vault.core.world.processor.ProcessorContext;
import iskallia.vault.core.world.template.JigsawTemplate;
import iskallia.vault.core.world.template.PlacementSettings;
import iskallia.vault.core.world.template.Template;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.condition.RoomGenerationCondition;
import iskallia.vault.task.condition.TaskCondition;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class FindVaultRoomTask
extends ProgressConfiguredTask<Integer, Config> {
    private Set<BlockPos> found = new HashSet<BlockPos>();
    private transient TaskContext context;
    public static ArrayAdapter<BlockPos> POSITIONS = Adapters.ofArray(BlockPos[]::new, Adapters.BLOCK_POS);

    public FindVaultRoomTask() {
        super(new Config(), TaskCounter.Adapter.INT);
        this.initCondition();
    }

    public FindVaultRoomTask(Config config, TaskCounter<Integer, ?> counter) {
        super(config, counter, TaskCounter.Adapter.INT);
        this.initCondition();
    }

    private void initCondition() {
        ResourceLocation[] filter = ((Config)this.getConfig()).getFilter();
        if (filter != null && filter.length > 0) {
            RoomGenerationCondition condition = new RoomGenerationCondition();
            ((RoomGenerationCondition.Config)condition.getConfig()).setFilter(Arrays.asList(filter));
            this.condition = condition;
        }
    }

    @Override
    public void onAttach(TaskContext context) {
        super.onAttach(context);
        this.context = context;
        CommonEvents.LISTENER_JOIN.register(this, data -> {
            if (data.getVault() != context.getVault()) {
                return;
            }
            this.revalidateTarget();
        });
        CommonEvents.LISTENER_TICK.register(this, data -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            TaskSource patt2922$temp = context.getSource();
            if (!(patt2922$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt2922$temp;
            if (!entitySource.matches(data.getListener().getId())) {
                return;
            }
            ServerPlayer player = data.getListener().getPlayer().orElse(null);
            if (player == null || player.m_183503_() != data.getWorld()) {
                return;
            }
            VaultGenerator patt3286$temp = data.getVault().get(Vault.WORLD).get(WorldManager.GENERATOR);
            if (!(patt3286$temp instanceof GridGenerator)) {
                return;
            }
            GridGenerator generator = (GridGenerator)patt3286$temp;
            GridLayout patt3385$temp = generator.get(GridGenerator.LAYOUT);
            if (!(patt3385$temp instanceof VaultGridLayout)) {
                return;
            }
            VaultGridLayout layout = (VaultGridLayout)patt3385$temp;
            RegionPos region = RegionPos.ofBlockPos(player.m_142538_(), generator.get(GridGenerator.CELL_X), generator.get(GridGenerator.CELL_Z));
            if (this.found.contains(new BlockPos(region.m_123341_(), 0, region.m_123343_()))) {
                return;
            }
            ChunkRandom random = ChunkRandom.any();
            random.setRegionSeed(data.getVault().get(Vault.SEED), region.m_123341_(), region.m_123343_(), 1234567890L);
            PlacementSettings settings = new PlacementSettings(new ProcessorContext(data.getVault(), random)).setFlags(272);
            VaultLayout.PieceType type = layout.getType(data.getVault(), region);
            if (type != VaultLayout.PieceType.ROOM) {
                return;
            }
            Template template = layout.getAt(data.getVault(), region, random, settings);
            if (template instanceof JigsawTemplate) {
                JigsawTemplate jigsaw = (JigsawTemplate)template;
                template = jigsaw.getRoot();
            }
            if (((Config)this.getConfig()).getFilter() == null) {
                this.found.add(new BlockPos(region.m_123341_(), 0, region.m_123343_()));
                this.getCounter().onAdd(1, context);
                return;
            }
            for (ResourceLocation id : ((Config)this.getConfig()).getFilter()) {
                if (template == null || !id.equals((Object)template.getKey().getId())) continue;
                this.found.add(new BlockPos(region.m_123341_(), 0, region.m_123343_()));
                this.getCounter().onAdd(1, context);
                break;
            }
        });
        this.revalidateTarget();
    }

    private void revalidateTarget() {
        TaskCondition taskCondition = this.condition;
        if (!(taskCondition instanceof RoomGenerationCondition)) {
            return;
        }
        RoomGenerationCondition condition = (RoomGenerationCondition)taskCondition;
        if (this.context == null) {
            return;
        }
        condition.isConditionFulfilled(this, this.context);
    }

    @Override
    public void onDetach() {
        this.context = null;
        super.onDetach();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        POSITIONS.writeBits((BlockPos)((BlockPos[])this.found.toArray(BlockPos[]::new)), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.found = new HashSet<BlockPos>(Arrays.asList(POSITIONS.readBits(buffer).orElse(new BlockPos[0])));
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            POSITIONS.writeNbt((BlockPos)((BlockPos[])this.found.toArray(BlockPos[]::new))).ifPresent(tag -> nbt.m_128365_("found", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.found = new HashSet<BlockPos>(Arrays.asList(POSITIONS.readNbt(nbt.m_128423_("found")).orElse(new BlockPos[0])));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            POSITIONS.writeJson((BlockPos)((BlockPos[])this.found.toArray(BlockPos[]::new))).ifPresent(tag -> json.add("found", tag));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.found = new HashSet<BlockPos>(Arrays.asList(POSITIONS.readJson(json.get("found")).orElse(new BlockPos[0])));
    }

    public static class Config
    extends ConfiguredTask.Config {
        private ResourceLocation[] filter;
        public static final ArrayAdapter<ResourceLocation> TEMPLATES = Adapters.ofArray(ResourceLocation[]::new, Adapters.IDENTIFIER).asNullable();

        public Config() {
            this.filter = new ResourceLocation[0];
        }

        public Config(ResourceLocation[] filter) {
            this.filter = filter;
        }

        public ResourceLocation[] getFilter() {
            return this.filter;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            TEMPLATES.writeBits((ResourceLocation)this.filter, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.filter = TEMPLATES.readBits(buffer).orElse(null);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                TEMPLATES.writeNbt((ResourceLocation)this.filter).ifPresent(value -> nbt.m_128365_("filter", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.filter = TEMPLATES.readNbt(nbt.m_128423_("filter")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                TEMPLATES.writeJson((ResourceLocation)this.filter).ifPresent(value -> json.add("filter", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.filter = TEMPLATES.readJson(json.get("filter")).orElse(null);
        }
    }
}

