/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.objective.Objectives;
import iskallia.vault.core.vault.player.Completion;
import iskallia.vault.core.vault.stat.StatCollector;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class FinishVaultTask
extends ProgressConfiguredTask<Integer, Config> {
    public FinishVaultTask() {
        super(new Config(), TaskCounter.Adapter.INT);
    }

    public FinishVaultTask(Config config, TaskCounter<Integer, ?> counter) {
        super(config, counter, TaskCounter.Adapter.INT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.LISTENER_LEAVE.register(this, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            TaskSource patt1418$temp = context.getSource();
            if (!(patt1418$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource source = (EntityTaskSource)patt1418$temp;
            if (!source.matches(event.getListener().getId())) {
                return;
            }
            Completion completion = event.getVault().get(Vault.STATS).get(event.getListener()).get(StatCollector.COMPLETION);
            if (((Config)this.getConfig()).completion != null && !((Config)this.getConfig()).completion.contains((Object)completion)) {
                return;
            }
            String objective = event.getVault().get(Vault.OBJECTIVES).get(Objectives.KEY);
            if (((Config)this.getConfig()).objective != null && !((Config)this.getConfig()).objective.contains(objective)) {
                return;
            }
            this.counter.onAdd(1, context);
        });
        super.onAttach(context);
    }

    public static class Config
    extends ConfiguredTask.Config {
        protected static final ArrayAdapter<Completion> COMPLETION = Adapters.ofArray(Completion[]::new, Adapters.ofEnum(Completion.class, EnumAdapter.Mode.NAME));
        protected static final ArrayAdapter<String> OBJECTIVE = Adapters.ofArray(String[]::new, Adapters.UTF_8);
        private Set<Completion> completion;
        @Nullable
        private Set<String> objective;

        public Config() {
        }

        public Config(Set<Completion> completion, @Nullable Set<String> objective) {
            this.completion = completion;
            this.objective = objective;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            COMPLETION.writeBits((Completion)((Completion[])this.completion.toArray(Completion[]::new)), buffer);
            OBJECTIVE.asNullable().writeBits((String)(this.objective == null ? null : (String[])this.objective.toArray(String[]::new)), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.completion = Arrays.stream(COMPLETION.readBits(buffer).orElse(new Completion[0])).collect(Collectors.toSet());
            this.objective = OBJECTIVE.asNullable().readBits(buffer).map(arr -> Arrays.stream(arr).collect(Collectors.toSet())).orElse(null);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                COMPLETION.writeNbt((Completion)((Completion[])this.completion.toArray(Completion[]::new))).ifPresent(tag -> nbt.m_128365_("completion", tag));
                OBJECTIVE.asNullable().writeNbt((String)(this.objective == null ? null : (String[])this.objective.toArray(String[]::new))).ifPresent(tag -> nbt.m_128365_("objective", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.completion = Arrays.stream(COMPLETION.readNbt(nbt.m_128423_("completion")).orElse(new Completion[0])).collect(Collectors.toSet());
            this.objective = OBJECTIVE.asNullable().readNbt(nbt.m_128423_("objective")).map(arr -> Arrays.stream(arr).collect(Collectors.toSet())).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                COMPLETION.writeJson((Completion)((Completion[])this.completion.toArray(Completion[]::new))).ifPresent(tag -> json.add("completion", tag));
                OBJECTIVE.asNullable().writeJson((String)(this.objective == null ? null : (String[])this.objective.toArray(String[]::new))).ifPresent(tag -> json.add("objective", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.completion = Arrays.stream(COMPLETION.readJson(json.get("completion")).orElse(new Completion[0])).collect(Collectors.toSet());
            this.objective = OBJECTIVE.asNullable().readJson(json.get("objective")).map(arr -> Arrays.stream(arr).collect(Collectors.toSet())).orElse(null);
        }
    }
}

