/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.block.base.GodAltarTileEntity;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Modifiers;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultLevel;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.core.vault.modifier.modifier.NoLootModifier;
import iskallia.vault.core.vault.modifier.spi.ModifierContext;
import iskallia.vault.core.vault.modifier.spi.VaultModifier;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.TimedTask;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.world.data.PlayerReputationData;
import iskallia.vault.world.data.ServerVaults;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.TickEvent;

public class GodAltarTask
extends Task {
    private UUID altarUuid;
    private UUID vaultUuid;
    private VaultGod god;
    private ResourceKey<Level> dimension;
    private BlockPos pos;
    protected ResourceLocation modifierCompletionPool;
    protected ResourceLocation modifierFailurePool;
    private TimedTask child;
    private boolean expired;
    private static final ResourceLocation MODIFIER_GROUP = VaultMod.id("god_altar");
    public static final Map<VaultGod, List<String>> FAILURE_MESSAGES = new HashMap<VaultGod, List<String>>();
    public static final Map<VaultGod, List<String>> COMPLETION_MESSAGES = new HashMap<VaultGod, List<String>>();

    public GodAltarTask() {
    }

    public GodAltarTask(GodAltarTileEntity entity, UUID altarUuid, UUID vaultUuid, long duration, ResourceLocation modifierCompletionPool, ResourceLocation modifierFailurePool, VaultGod god, Task child) {
        this.altarUuid = altarUuid;
        this.vaultUuid = vaultUuid;
        this.god = god;
        this.dimension = entity.m_58904_().m_46472_();
        this.pos = entity.m_58899_();
        this.modifierCompletionPool = modifierCompletionPool;
        this.modifierFailurePool = modifierFailurePool;
        this.child = (TimedTask)new TimedTask(duration).addChildren(new Task[]{child});
        this.expired = false;
    }

    public UUID getAltarUuid() {
        return this.altarUuid;
    }

    public VaultGod getGod() {
        return this.god;
    }

    public TimedTask getChild() {
        return this.child;
    }

    public boolean isExpired() {
        return this.expired;
    }

    @Override
    public Iterable<Task> getChildren() {
        return Collections.singleton(this.child);
    }

    @Override
    public boolean isCompleted() {
        return !this.expired;
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(this, event -> {
            TaskSource patt3816$temp;
            if (this.expired) {
                return;
            }
            Vault vault = ServerVaults.get(this.vaultUuid).orElse(null);
            if (this.vaultUuid != null && vault == null) {
                this.onFail(null, context);
                return;
            }
            if (vault != null && (patt3816$temp = context.getSource()) instanceof EntityTaskSource) {
                EntityTaskSource entitySource = (EntityTaskSource)patt3816$temp;
                for (UUID uuid : entitySource.getUuids()) {
                    if (vault.get(Vault.LISTENERS).contains(uuid)) continue;
                    this.onFail(vault, context);
                    return;
                }
            }
            if (this.child.isCompleted() && this.child.streamDescendants().allMatch(Task::isCompleted)) {
                this.onSucceed(vault, context);
            } else if (!this.child.isCompleted()) {
                this.onFail(vault, context);
            }
        });
        super.onAttach(context);
    }

    public void onFail(Vault vault, TaskContext context) {
        this.expired = true;
        TaskSource taskSource = context.getSource();
        if (taskSource instanceof EntityTaskSource) {
            EntityTaskSource entitySource = (EntityTaskSource)taskSource;
            for (Player player : entitySource.getEntities(Player.class)) {
                if (PlayerReputationData.getReputation(player.m_142081_(), this.god) <= 0) continue;
                PlayerReputationData.addReputation(player.m_142081_(), this.god, -1);
            }
        }
        this.doCompletionEffects(vault, context, true);
        CommonEvents.GOD_ALTAR_EVENT.invoke(this, vault, this.pos, context, false);
    }

    public void onSucceed(Vault vault, TaskContext context) {
        BlockEntity blockEntity;
        ServerLevel world;
        this.expired = true;
        this.doCompletionEffects(vault, context, false);
        CommonEvents.GOD_ALTAR_EVENT.invoke(this, vault, this.pos, context, true);
        if (vault.get(Vault.MODIFIERS).getModifiers().stream().anyMatch(modifier -> modifier instanceof NoLootModifier)) {
            return;
        }
        TaskSource taskSource = context.getSource();
        if (taskSource instanceof EntityTaskSource) {
            EntityTaskSource entitySource = (EntityTaskSource)taskSource;
            for (Player player : entitySource.getEntities(Player.class)) {
                PlayerReputationData.attemptFavour(player, this.god);
            }
        }
        if ((world = context.getServer().m_129880_(this.dimension)) != null && (blockEntity = world.m_7702_(this.pos)) instanceof GodAltarTileEntity) {
            GodAltarTileEntity altar = (GodAltarTileEntity)blockEntity;
            altar.placeReward((Level)world, this.pos.m_7494_(), this.god);
        }
    }

    public void doCompletionEffects(Vault vault, TaskContext context, boolean failure) {
        Iterator it2;
        int level = vault == null ? 0 : vault.getOptional(Vault.LEVEL).map(VaultLevel::get).orElse(0);
        List<Object> modifiers = new ArrayList();
        if (!failure) {
            modifiers = ModConfigs.VAULT_MODIFIER_POOLS.getRandom(this.modifierCompletionPool, level, context.getSource().getRandom());
        }
        Object2IntOpenHashMap groups = new Object2IntOpenHashMap();
        modifiers.forEach(arg_0 -> GodAltarTask.lambda$doCompletionEffects$2((Object2IntMap)groups, arg_0));
        TextComponent suffix = new TextComponent("");
        ObjectIterator it1 = groups.object2IntEntrySet().iterator();
        while (it1.hasNext()) {
            Object2IntMap.Entry entry = (Object2IntMap.Entry)it1.next();
            suffix.m_7220_(((VaultModifier)entry.getKey()).getChatDisplayNameComponent(entry.getIntValue()));
            if (!it1.hasNext()) continue;
            suffix.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent prefix = new TextComponent("");
        TaskSource taskSource = context.getSource();
        if (taskSource instanceof EntityTaskSource) {
            EntityTaskSource source = (EntityTaskSource)taskSource;
            v0 = source.getEntities(Entity.class).iterator();
        } else {
            v0 = it2 = Collections.emptyIterator();
        }
        while (it2.hasNext()) {
            prefix.m_7220_(((Entity)it2.next()).m_5446_());
            if (!it2.hasNext()) continue;
            prefix.m_7220_((Component)new TextComponent(", "));
        }
        TextComponent text = new TextComponent("");
        if (!modifiers.isEmpty()) {
            text.m_7220_((Component)prefix).m_7220_((Component)new TextComponent(" added ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)suffix).m_7220_((Component)new TextComponent(".").m_130940_(ChatFormatting.GRAY));
        }
        HashSet<Player> notified = new HashSet<Player>();
        TaskSource taskSource2 = context.getSource();
        if (taskSource2 instanceof EntityTaskSource) {
            EntityTaskSource source = (EntityTaskSource)taskSource2;
            notified.addAll(source.getEntities(Player.class));
        }
        if (vault != null) {
            groups.forEach((modifier, count) -> vault.ifPresent(Vault.MODIFIERS, value -> {
                if (failure) {
                    return;
                }
                for (Modifiers.Entry entry : value.getEntries()) {
                    if (!MODIFIER_GROUP.equals((Object)entry.get(Modifiers.Entry.CONTEXT).get(ModifierContext.GROUP))) continue;
                    entry.get(Modifiers.Entry.CONTEXT).setExpired();
                }
                value.addModifier((VaultModifier<?>)modifier, (int)count, true, context.getSource().getRandom(), modifierContext -> modifierContext.set(ModifierContext.GROUP, MODIFIER_GROUP));
            }));
            for (Listener listener : vault.get(Vault.LISTENERS).getAll()) {
                listener.getPlayer().ifPresent(notified::add);
            }
        }
        List<String> messagePool = (failure ? FAILURE_MESSAGES : COMPLETION_MESSAGES).get((Object)this.god);
        String message = messagePool.get(context.getSource().getRandom().nextInt(messagePool.size()));
        MutableComponent vgName = new TextComponent(this.god.getName()).m_130940_(this.god.getChatColor());
        vgName.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.god.getHoverChatComponent())));
        MutableComponent txt = new TextComponent("").m_7220_((Component)vgName).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(message));
        for (Player other : notified) {
            if (failure) {
                other.f_19853_.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_11703_, SoundSource.PLAYERS, 0.9f, 0.5f);
            } else {
                other.f_19853_.m_6263_(null, other.m_20185_(), other.m_20186_(), other.m_20189_(), SoundEvents.f_12210_, SoundSource.PLAYERS, 0.9f, 1.2f);
            }
            other.m_5661_((Component)txt, false);
            if (modifiers.isEmpty()) continue;
            other.m_5661_((Component)text, false);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.UUID.writeBits(this.altarUuid, buffer);
        Adapters.UUID.writeBits(this.vaultUuid, buffer);
        Adapters.GOD_NAME.writeBits(this.god, buffer);
        Adapters.DIMENSION.writeBits(this.dimension, buffer);
        Adapters.BLOCK_POS.writeBits(this.pos, buffer);
        Adapters.IDENTIFIER.writeBits(this.modifierCompletionPool, buffer);
        Adapters.IDENTIFIER.writeBits(this.modifierFailurePool, buffer);
        Adapters.TASK.writeBits(this.child, buffer);
        Adapters.BOOLEAN.writeBits(this.expired, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.altarUuid = Adapters.UUID.readBits(buffer).orElseThrow();
        this.vaultUuid = Adapters.UUID.readBits(buffer).orElseThrow();
        this.god = Adapters.GOD_NAME.readBits(buffer).orElseThrow();
        this.dimension = Adapters.DIMENSION.readBits(buffer).orElseThrow();
        this.pos = Adapters.BLOCK_POS.readBits(buffer).orElseThrow();
        this.modifierCompletionPool = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
        this.modifierFailurePool = Adapters.IDENTIFIER.readBits(buffer).orElseThrow();
        this.child = (TimedTask)Adapters.TASK.readBits(buffer).orElseThrow();
        this.expired = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.UUID.writeNbt(this.altarUuid).ifPresent(value -> nbt.m_128365_("altarUuid", value));
            Adapters.UUID.writeNbt(this.vaultUuid).ifPresent(value -> nbt.m_128365_("vaultUuid", value));
            Adapters.GOD_NAME.writeNbt(this.god).ifPresent(value -> nbt.m_128365_("god", value));
            Adapters.DIMENSION.writeNbt(this.dimension).ifPresent(value -> nbt.m_128365_("dimension", value));
            Adapters.BLOCK_POS.writeNbt(this.pos).ifPresent(value -> nbt.m_128365_("pos", value));
            Adapters.IDENTIFIER.writeNbt(this.modifierCompletionPool).ifPresent(value -> nbt.m_128365_("modifierCompletionPool", value));
            Adapters.IDENTIFIER.writeNbt(this.modifierFailurePool).ifPresent(value -> nbt.m_128365_("modifierFailurePool", value));
            Adapters.TASK.writeNbt(this.child).ifPresent(value -> nbt.m_128365_("child", value));
            Adapters.BOOLEAN.writeNbt(this.expired).ifPresent(value -> nbt.m_128365_("expired", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.altarUuid = Adapters.UUID.readNbt(nbt.m_128423_("altarUuid")).orElse(null);
        this.vaultUuid = Adapters.UUID.readNbt(nbt.m_128423_("vaultUuid")).orElse(null);
        this.god = Adapters.GOD_NAME.readNbt(nbt.m_128423_("god")).orElse(null);
        this.dimension = Adapters.DIMENSION.readNbt(nbt.m_128423_("dimension")).orElse(null);
        this.pos = Adapters.BLOCK_POS.readNbt(nbt.m_128423_("pos")).orElse(null);
        this.modifierCompletionPool = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("modifierCompletionPool")).orElse(null);
        this.modifierFailurePool = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("modifierFailurePool")).orElse(null);
        this.child = Adapters.TASK.readNbt(nbt.m_128423_("child")).orElse(null);
        this.expired = Adapters.BOOLEAN.readNbt(nbt.m_128423_("expired")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.UUID.writeJson(this.altarUuid).ifPresent(value -> json.add("altarUuid", value));
            Adapters.UUID.writeJson(this.vaultUuid).ifPresent(value -> json.add("vaultUuid", value));
            Adapters.GOD_NAME.writeJson(this.god).ifPresent(value -> json.add("god", value));
            Adapters.DIMENSION.writeJson(this.dimension).ifPresent(value -> json.add("dimension", value));
            Adapters.BLOCK_POS.writeJson(this.pos).ifPresent(value -> json.add("pos", value));
            Adapters.IDENTIFIER.writeJson(this.modifierCompletionPool).ifPresent(value -> json.add("modifierCompletionPool", value));
            Adapters.IDENTIFIER.writeJson(this.modifierFailurePool).ifPresent(value -> json.add("modifierFailurePool", value));
            Adapters.TASK.writeJson(this.child).ifPresent(value -> json.add("child", value));
            Adapters.BOOLEAN.writeJson(this.expired).ifPresent(value -> json.add("expired", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.altarUuid = Adapters.UUID.readJson(json.get("altarUuid")).orElse(null);
        this.vaultUuid = Adapters.UUID.readJson(json.get("vaultUuid")).orElse(null);
        this.god = Adapters.GOD_NAME.readJson(json.get("god")).orElse(null);
        this.dimension = Adapters.DIMENSION.readJson(json.get("dimension")).orElse(null);
        this.pos = Adapters.BLOCK_POS.readJson(json.get("pos")).orElse(null);
        this.modifierCompletionPool = Adapters.IDENTIFIER.readJson(json.get("modifierCompletionPool")).orElse(null);
        this.modifierFailurePool = Adapters.IDENTIFIER.readJson(json.get("modifierFailurePool")).orElse(null);
        this.child = Adapters.TASK.readJson(json.get("child")).orElse(null);
        this.expired = Adapters.BOOLEAN.readJson(json.get("expired")).orElse(false);
    }

    private static /* synthetic */ void lambda$doCompletionEffects$2(Object2IntMap groups, VaultModifier modifier) {
        groups.put((Object)modifier, groups.getOrDefault((Object)modifier, 0) + 1);
    }

    static {
        FAILURE_MESSAGES.put(VaultGod.VELARA, Arrays.asList("The harmony of the natural world eludes you.", "The beauty of nature thrives on resilience, but your actions have brought only discord.", "Your failures wither the very essence of life.", "The song of nature laments your inadequacy.", "You tarnish the purity of nature with your missteps."));
        FAILURE_MESSAGES.put(VaultGod.TENOS, Arrays.asList("Even the wisest can stumble on their path to enlightenment.", "Seek knowledge, learn from your failures, and you shall find your way.", "Failure is but a stepping stone on the road to enlightenment.", "Even the most brilliant minds face setbacks.", "In the pursuit of wisdom, missteps are bound to occur."));
        FAILURE_MESSAGES.put(VaultGod.WENDARR, Arrays.asList("A moment lost is a chance wasted.", "The sands of time never cease their relentless march.", "In the grand tapestry of existence, your actions are but threads.", "Time's embrace can be both cruel and kind.", "As the clock ticks, so do your choices shape your destiny."));
        FAILURE_MESSAGES.put(VaultGod.IDONA, Arrays.asList("Perhaps you should consider a different path.", "Weakness is a burden that few can afford.", "Your feeble attempt have left much to be desired.", "A hunter must be swift to adapt, or they are doomed to fail.", "No smiles will be cast upon those who crumble in the face of adversity."));
        COMPLETION_MESSAGES.put(VaultGod.VELARA, Arrays.asList("Our domain's ground will carve a path.", "Tread upon our domain with care and it will respond in kind.", "May your desire blossom into a wildfire.", "Creation bends to our will.", "The soil whispers secrets of those who've walked before.", "Beneath the surface, our whispers guide fate.", "Our heartbeats sync with the world's tremors.", "Our reach extends beyond the visible horizon."));
        COMPLETION_MESSAGES.put(VaultGod.TENOS, Arrays.asList("May foresight guide your step.", "Careful planning and strategy may lead you.", "A set choice; followed through and flawlessly executed.", "Chance's hand may favour your goals.", "In the dance of fate and strategy, precision reigns.", "To foresee is to command the threads of destiny.", "Tread lightly on the line between choice and predestination.", "To conquer fate, first understand its riddles."));
        COMPLETION_MESSAGES.put(VaultGod.WENDARR, Arrays.asList("Seize the opportunity.", "A single instant, stretched to infinity.", "Your future glows golden with possibility.", "Hasten and value every passing moment.", "With every heartbeat, an epoch is born.", "The sands of time are fleeting; grasp them.", "The dance of time is swift; miss not its rhythm.", "The pendulum of time swings but once for each moment."));
        COMPLETION_MESSAGES.put(VaultGod.IDONA, Arrays.asList("Enforce your path through obstacles.", "Our vigor may aid your conquest.", "Cherish this mote of my might.", "A tempest incarnate.", "Rise, like the waves, unyielding and fierce.", "Forge ahead with the fury of storms.", "With relentless force, mold your path.", "Harness my wrath to awaken the dormant."));
    }
}

