/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.config.entry.LevelEntryList;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.util.WeightedList;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.renderer.GreedRenderer;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.LootInitialization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class GreedTask
extends ConfiguredTask<Config>
implements LevelEntryList.ILevelEntry {
    private int amount;
    private Task[] tasks;
    private ItemStack[] rewards;
    private boolean[] completed;
    private static final ArrayAdapter<Task> TASKS = Adapters.ofArray(Task[]::new, Adapters.TASK);
    private static final ArrayAdapter<ItemStack> ITEMS = Adapters.ofArray(ItemStack[]::new, Adapters.ITEM_STACK);

    public GreedTask() {
        super(new Config());
    }

    public GreedTask(Config config) {
        super(config);
    }

    public int getLength() {
        return this.tasks.length;
    }

    public Task getTask(int index) {
        return this.tasks[index];
    }

    public boolean isTaskCompleted(int index) {
        return this.completed[index];
    }

    public boolean areAllCompleted() {
        for (boolean value : this.completed) {
            if (value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCompleted() {
        return this.areAllCompleted();
    }

    public boolean isCompleted(int index) {
        return this.completed[index];
    }

    @Override
    public Iterable<Task> getChildren() {
        return Arrays.asList(this.tasks);
    }

    @Override
    public void onPopulate(TaskContext context) {
        int i;
        this.amount = ((Config)this.getConfig()).amount.get(context.getSource().getRandom());
        this.tasks = new Task[this.amount];
        this.rewards = new ItemStack[this.amount];
        this.completed = new boolean[this.amount];
        WeightedList<Task> taskPool = ((Config)this.getConfig()).getTasks(context);
        WeightedList<ItemStack> rewardPool = ((Config)this.getConfig()).getRewards(context);
        taskPool.keySet().forEach(task -> task.getSelfAndChildren().forEach(subTask -> {
            if (subTask instanceof ProgressConfiguredTask) {
                ProgressConfiguredTask progressTask = (ProgressConfiguredTask)subTask;
                progressTask.getCounter().populate(context);
            }
        }));
        taskPool.keySet().removeIf(task -> {
            ProgressConfiguredTask progressTask;
            return task instanceof ProgressConfiguredTask && (progressTask = (ProgressConfiguredTask)task).getCondition() != null && !progressTask.getCondition().isConditionFulfilled(progressTask, context);
        });
        ArrayList<Object> selectedTasks = new ArrayList<Object>();
        while (selectedTasks.size() < this.amount) {
            if (selectedTasks.size() + taskPool.size() < this.amount) {
                selectedTasks.addAll(taskPool.keySet());
                continue;
            }
            taskPool.getRandom(context.getSource().getRandom()).ifPresent(key -> {
                selectedTasks.add(key);
                taskPool.remove(key);
            });
        }
        for (i = selectedTasks.size() - 1; i > 0; --i) {
            selectedTasks.set(i, selectedTasks.set(context.getSource().getRandom().nextInt(i + 1), (Task)selectedTasks.get(i)));
        }
        for (i = 0; i < this.amount; ++i) {
            this.tasks[i] = ((Task)selectedTasks.get(i)).copy();
            ItemStack stack = rewardPool.getRandom(context.getSource().getRandom()).map(ItemStack::m_41777_).orElse(ItemStack.f_41583_);
            this.rewards[i] = LootInitialization.initializeVaultLoot(stack, context.getVault(), null, context.getSource().getRandom());
        }
    }

    @Override
    public void onAttach(TaskContext context) {
        super.onAttach(context);
        for (int i = 0; i < this.tasks.length; ++i) {
            Task task = this.getChild(i);
            if (!this.completed[i]) continue;
            this.onComplete(task, context);
            task.onDetach();
        }
    }

    private void onComplete(Task task, TaskContext context) {
        String name = task.streamSelfAndDescendants().flatMap(child -> {
            TaskRenderer patt5166$temp = child.getRenderer();
            if (patt5166$temp instanceof GreedRenderer.Leaf) {
                GreedRenderer.Leaf renderer = (GreedRenderer.Leaf)patt5166$temp;
                return Stream.of(renderer.name);
            }
            return Stream.empty();
        }).findFirst().orElse("Unknown");
        for (Listener listener : context.getVault().get(Vault.LISTENERS).getAll()) {
            listener.getPlayer().ifPresent(player -> {
                player.m_5661_((Component)new TextComponent("").m_7220_((Component)new TextComponent("Completed ").m_130940_(ChatFormatting.GRAY)).m_130946_(name).m_7220_((Component)new TextComponent("!").m_130940_(ChatFormatting.GRAY)), false);
                player.f_19853_.m_6269_(null, (Entity)player, SoundEvents.f_12211_, SoundSource.MASTER, 0.75f, 0.75f + player.f_19853_.m_5822_().nextFloat() * 0.25f);
            });
        }
    }

    @Override
    public void onTick(TaskContext context) {
        super.onTick(context);
        for (int i = 0; i < this.tasks.length; ++i) {
            Task task = this.tasks[i];
            if (this.completed[i] || !task.streamSelfAndDescendants().allMatch(Task::isCompleted)) continue;
            this.giveReward(i, context);
            this.onComplete(task, context);
            this.completed[i] = true;
            task.onDetach();
        }
    }

    private void giveReward(int index, TaskContext context) {
        TaskSource taskSource = context.getSource();
        if (!(taskSource instanceof EntityTaskSource)) {
            return;
        }
        EntityTaskSource source = (EntityTaskSource)taskSource;
        ItemStack stack = this.rewards[index];
        for (ServerPlayer player : source.getEntities(context.getServer(), ServerPlayer.class)) {
            EntityHelper.giveItem((Player)player, stack.m_41777_());
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        Adapters.INT_SEGMENTED_7.writeBits(this.amount, buffer);
        TASKS.writeBits((Task)this.tasks, buffer);
        ITEMS.writeBits((ItemStack)this.rewards, buffer);
        Adapters.BOOLEAN_ARRAY.writeBits(this.completed, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        if (!this.isPopulated()) {
            return;
        }
        this.amount = Adapters.INT_SEGMENTED_7.readBits(buffer).orElse(0);
        this.tasks = TASKS.readBits(buffer).orElse(new Task[0]);
        this.rewards = ITEMS.readBits(buffer).orElse(new ItemStack[0]);
        this.completed = Adapters.BOOLEAN_ARRAY.readBits(buffer).orElse(new boolean[0]);
        Arrays.stream(this.tasks).forEach(task -> {
            task.parent = this;
        });
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            if (!this.isPopulated()) {
                return nbt;
            }
            Adapters.INT.writeNbt(this.amount).ifPresent(tag -> nbt.m_128365_("amount", tag));
            TASKS.writeNbt((Task)this.tasks).ifPresent(tag -> nbt.m_128365_("tasks", tag));
            ITEMS.writeNbt((ItemStack)this.rewards).ifPresent(tag -> nbt.m_128365_("rewards", tag));
            Adapters.BOOLEAN_ARRAY.writeNbt(this.completed).ifPresent(tag -> nbt.m_128365_("completed", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        if (!this.isPopulated()) {
            return;
        }
        this.amount = Adapters.INT.readNbt(nbt.m_128423_("amount")).orElse(0);
        this.tasks = TASKS.readNbt(nbt.m_128423_("tasks")).orElse(new Task[0]);
        this.rewards = ITEMS.readNbt(nbt.m_128423_("rewards")).orElse(new ItemStack[0]);
        this.completed = Adapters.BOOLEAN_ARRAY.readNbt(nbt.m_128423_("completed")).orElse(new boolean[0]);
        Arrays.stream(this.tasks).forEach(task -> {
            task.parent = this;
        });
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            if (!this.isPopulated()) {
                return json;
            }
            Adapters.INT.writeJson(this.amount).ifPresent(value -> json.add("amount", value));
            TASKS.writeJson((Task)this.tasks).ifPresent(value -> json.add("tasks", value));
            ITEMS.writeJson((ItemStack)this.rewards).ifPresent(value -> json.add("rewards", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        if (!this.isPopulated()) {
            return;
        }
        this.amount = Adapters.INT.readJson(json.get("amount")).orElse(0);
        this.tasks = TASKS.readJson(json.get("tasks")).orElse(new Task[0]);
        this.rewards = ITEMS.readJson(json.get("rewards")).orElse(new ItemStack[0]);
        Arrays.stream(this.tasks).forEach(task -> {
            task.parent = this;
        });
    }

    @Override
    public int getLevel() {
        return ((Config)this.getConfig()).level;
    }

    public int getCompletedTasks() {
        int count = 0;
        for (boolean value : this.completed) {
            count += value ? 1 : 0;
        }
        return count;
    }

    public int getAmount() {
        return this.amount;
    }

    public Task getChild(int index) {
        return this.tasks[index];
    }

    public Optional<ItemStack> getReward(int i) {
        return i < this.rewards.length ? Optional.of(this.rewards[i]) : Optional.empty();
    }

    public static class Config
    extends ConfiguredTask.Config {
        private int level;
        private IntRoll amount;
        private final Map<Integer, WeightedList<Task>> tasks = new HashMap<Integer, WeightedList<Task>>();
        public final Map<Integer, WeightedList<ItemStack>> rewards = new HashMap<Integer, WeightedList<ItemStack>>();

        public Config() {
        }

        public Config(IntRoll amount) {
            this();
            this.amount = amount;
        }

        public Config(IntRoll amount, int level, Map<Integer, WeightedList<Task>> tasks, Map<Integer, WeightedList<ItemStack>> rewards) {
            this();
            this.level = level;
            this.amount = amount;
            this.tasks.putAll(tasks);
            this.rewards.putAll(rewards);
        }

        private WeightedList<Task> getTasks(TaskContext context) {
            WeightedList<Task> result = new WeightedList<Task>();
            this.tasks.forEach((level, pool) -> {
                if (level <= context.getLevel()) {
                    result.putAll(pool);
                }
            });
            return result;
        }

        private WeightedList<ItemStack> getRewards(TaskContext context) {
            WeightedList<ItemStack> result = new WeightedList<ItemStack>();
            this.rewards.forEach((level, pool) -> {
                if (level <= context.getLevel()) {
                    result.putAll(pool);
                }
            });
            return result;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.level, buffer);
            Adapters.INT_ROLL.writeBits(this.amount, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.tasks.size(), buffer);
            this.tasks.forEach((level, pool) -> {
                Adapters.INT_SEGMENTED_7.writeBits(level, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(pool.size(), buffer);
                pool.forEach((task, weight) -> {
                    Adapters.TASK.writeBits(task, buffer);
                    Adapters.DOUBLE.writeBits(weight, buffer);
                });
            });
            Adapters.INT_SEGMENTED_7.writeBits(this.rewards.size(), buffer);
            this.rewards.forEach((level, pool) -> {
                Adapters.INT_SEGMENTED_7.writeBits(level, buffer);
                Adapters.INT_SEGMENTED_7.writeBits(pool.size(), buffer);
                pool.forEach((stack, weight) -> {
                    Adapters.ITEM_STACK.writeBits((ItemStack)stack, buffer);
                    Adapters.DOUBLE.writeBits(weight, buffer);
                });
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.level = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            this.amount = (IntRoll)Adapters.INT_ROLL.readBits(buffer).orElseThrow();
            this.tasks.clear();
            int tasksSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            for (int i = 0; i < tasksSize; ++i) {
                int level = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                int count = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                WeightedList<Task> pool = new WeightedList<Task>();
                for (int j = 0; j < count; ++j) {
                    Task task = (Task)Adapters.TASK.readBits(buffer).orElseThrow();
                    double weight = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
                    pool.put(task, weight);
                }
                this.tasks.put(level, pool);
            }
            this.rewards.clear();
            int rewardsSize = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
            for (int i = 0; i < rewardsSize; ++i) {
                int level = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                int count = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
                WeightedList<ItemStack> pool = new WeightedList<ItemStack>();
                for (int j = 0; j < count; ++j) {
                    ItemStack stack = Adapters.ITEM_STACK.readBits(buffer).orElseThrow();
                    double weight = (Double)Adapters.DOUBLE.readBits(buffer).orElseThrow();
                    pool.put(stack, weight);
                }
                this.rewards.put(level, pool);
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.INT.writeNbt(this.level).ifPresent(tag -> nbt.m_128365_("level", tag));
                Adapters.INT_ROLL.writeNbt(this.amount).ifPresent(tag -> nbt.m_128365_("amount", tag));
                ListTag tasksList = new ListTag();
                this.tasks.forEach((level, pool) -> pool.forEach((task, weight) -> Adapters.TASK.writeNbt(task).ifPresent(tag -> {
                    if (!(tag instanceof CompoundTag)) {
                        return;
                    }
                    CompoundTag compoundTag = (CompoundTag)tag;
                    Adapters.INT.writeNbt(level).ifPresent(t -> compoundTag.m_128405_("level", level.intValue()));
                    Adapters.DOUBLE.writeNbt(weight).ifPresent(w -> compoundTag.m_128347_("weight", weight.doubleValue()));
                    tasksList.add((Object)compoundTag);
                })));
                nbt.m_128365_("tasks", (Tag)tasksList);
                ListTag rewardsList = new ListTag();
                this.rewards.forEach((level, pool) -> pool.forEach((stack, weight) -> Adapters.ITEM_STACK.writeNbt((ItemStack)stack).ifPresent(tag -> {
                    if (!(tag instanceof CompoundTag)) {
                        return;
                    }
                    CompoundTag compoundTag = (CompoundTag)tag;
                    Adapters.INT.writeNbt(level).ifPresent(t -> compoundTag.m_128405_("level", level.intValue()));
                    Adapters.DOUBLE.writeNbt(weight).ifPresent(w -> compoundTag.m_128347_("weight", weight.doubleValue()));
                    rewardsList.add((Object)compoundTag);
                })));
                nbt.m_128365_("rewards", (Tag)rewardsList);
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.level = (Integer)Adapters.INT.readNbt(nbt.m_128423_("level")).orElseThrow();
            this.amount = (IntRoll)Adapters.INT_ROLL.readNbt(nbt.m_128423_("amount")).orElseThrow();
            this.tasks.clear();
            ListTag tasksList = nbt.m_128437_("tasks", 10);
            for (Tag element : tasksList) {
                if (!(element instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)element;
                Adapters.TASK.readNbt(element).ifPresent(task -> {
                    int level = Adapters.INT.readNbt(compoundTag.m_128423_("level")).orElse(0);
                    double weight = Adapters.DOUBLE.readNbt(compoundTag.m_128423_("weight")).orElse(0.0);
                    this.tasks.computeIfAbsent(level, k -> new WeightedList()).add(task, weight);
                });
            }
            this.rewards.clear();
            ListTag rewardsList = nbt.m_128437_("rewards", 10);
            for (Tag element : rewardsList) {
                if (!(element instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)element;
                Adapters.ITEM_STACK.readNbt(element).ifPresent(stack -> {
                    int level = Adapters.INT.readNbt(compoundTag.m_128423_("level")).orElse(0);
                    double weight = Adapters.DOUBLE.readNbt(compoundTag.m_128423_("weight")).orElse(0.0);
                    this.rewards.computeIfAbsent(level, k -> new WeightedList()).add(stack, weight);
                });
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.INT.writeJson(this.level).ifPresent(tag -> json.add("level", tag));
                Adapters.INT_ROLL.writeJson(this.amount).ifPresent(tag -> json.add("amount", tag));
                JsonArray tasksList = new JsonArray();
                this.tasks.forEach((level, pool) -> pool.forEach((task, weight) -> Adapters.TASK.writeJson(task).ifPresent(tag -> {
                    if (!(tag instanceof JsonObject)) {
                        return;
                    }
                    JsonObject jsonObject = (JsonObject)tag;
                    Adapters.INT.writeJson(level).ifPresent(t -> jsonObject.add("level", t));
                    Adapters.DOUBLE.writeJson(weight).ifPresent(t -> jsonObject.add("weight", t));
                    tasksList.add((JsonElement)jsonObject);
                })));
                json.add("tasks", (JsonElement)tasksList);
                JsonArray rewardsList = new JsonArray();
                this.rewards.forEach((level, pool) -> pool.forEach((stack, weight) -> Adapters.ITEM_STACK.writeJson((ItemStack)stack).ifPresent(tag -> {
                    if (!(tag instanceof JsonObject)) {
                        return;
                    }
                    JsonObject jsonObject = (JsonObject)tag;
                    Adapters.INT.writeJson(level).ifPresent(t -> jsonObject.add("level", t));
                    Adapters.DOUBLE.writeJson(weight).ifPresent(t -> jsonObject.add("weight", t));
                    rewardsList.add((JsonElement)jsonObject);
                })));
                json.add("rewards", (JsonElement)rewardsList);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.level = (Integer)Adapters.INT.readJson(json.get("level")).orElseThrow();
            this.amount = (IntRoll)Adapters.INT_ROLL.readJson(json.get("amount")).orElseThrow();
            this.tasks.clear();
            JsonArray tasksList = json.getAsJsonArray("tasks");
            if (tasksList != null) {
                for (JsonElement element : tasksList) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)element;
                    Adapters.TASK.readJson((JsonElement)jsonObject).ifPresent(task -> {
                        int level = Adapters.INT.readJson(jsonObject.get("level")).orElse(0);
                        double weight = Adapters.DOUBLE.readJson(jsonObject.get("weight")).orElse(0.0);
                        this.tasks.computeIfAbsent(level, k -> new WeightedList()).add(task, weight);
                    });
                }
            }
            this.rewards.clear();
            JsonArray rewardsList = json.getAsJsonArray("rewards");
            if (rewardsList != null) {
                for (JsonElement element : rewardsList) {
                    if (!(element instanceof JsonObject)) continue;
                    JsonObject jsonObject = (JsonObject)element;
                    Adapters.ITEM_STACK.readJson((JsonElement)jsonObject).ifPresent(stack -> {
                        int level = Adapters.INT.readJson(jsonObject.get("level")).orElse(0);
                        double weight = Adapters.DOUBLE.readJson(jsonObject.get("weight")).orElse(0.0);
                        this.rewards.computeIfAbsent(level, k -> new WeightedList()).add(stack, weight);
                    });
                }
            }
        }
    }
}

