/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ConsumableTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.util.EntityHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemRewardTask
extends ConsumableTask<Config> {
    public ItemRewardTask() {
        super(new Config());
    }

    public ItemRewardTask(Config config) {
        super(config);
    }

    @Override
    protected void onConsume(TaskContext context) {
        TaskSource taskSource = context.getSource();
        if (!(taskSource instanceof EntityTaskSource)) {
            return;
        }
        EntityTaskSource entityTaskSource = (EntityTaskSource)taskSource;
        for (ServerPlayer player : entityTaskSource.getEntities(ServerPlayer.class)) {
            for (ItemStack stack : ((Config)this.getConfig()).stacks) {
                ItemStack reward = stack.m_41777_();
                EntityHelper.giveItem((Player)player, reward);
            }
        }
    }

    public static class Config
    extends ConfiguredTask.Config {
        public List<ItemStack> stacks = new ArrayList<ItemStack>();
        private static final ArrayAdapter<ItemStack> ADAPTER = Adapters.ofArray(ItemStack[]::new, Adapters.ITEM_STACK);

        public Config() {
        }

        public Config(List<ItemStack> stacks) {
            this.stacks = stacks;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            ADAPTER.writeBits((ItemStack)((ItemStack[])this.stacks.toArray(ItemStack[]::new)), buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.stacks = Arrays.stream((ItemStack[])ADAPTER.readBits(buffer).orElseThrow()).toList();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                ADAPTER.writeNbt((ItemStack)((ItemStack[])this.stacks.toArray(ItemStack[]::new))).ifPresent(value -> nbt.m_128365_("stacks", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.stacks = Arrays.stream(ADAPTER.readNbt(nbt.m_128423_("stacks")).orElse(new ItemStack[0])).toList();
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                ADAPTER.writeJson((ItemStack)((ItemStack[])this.stacks.toArray(ItemStack[]::new))).ifPresent(value -> json.add("stacks", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.stacks = Arrays.stream(ADAPTER.readJson(json.get("stacks")).orElse(new ItemStack[0])).toList();
        }
    }
}

