/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.EntityPredicate;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.EventPriority;

public class KillEntityTask
extends ProgressConfiguredTask<Integer, Config> {
    public KillEntityTask() {
        super(new Config(), TaskCounter.Adapter.INT);
    }

    public KillEntityTask(Config config, TaskCounter<Integer, ?> counter) {
        super(config, counter, TaskCounter.Adapter.INT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.ENTITY_DROPS.register((Object)this, EventPriority.HIGHEST, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            Entity attacker = event.getSource().m_7639_();
            if (attacker == null || attacker.m_183503_().m_5776_()) {
                return;
            }
            TaskSource patt1256$temp = context.getSource();
            if (!(patt1256$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt1256$temp;
            if (attacker.m_183503_() != event.getEntity().m_183503_()) {
                return;
            }
            if (!entitySource.matches(attacker)) {
                return;
            }
            if (!((Config)this.getConfig()).filter.test(event.getEntity())) {
                return;
            }
            this.counter.onAdd(1, context);
        });
        super.onAttach(context);
    }

    public static class Config
    extends ConfiguredTask.Config {
        public EntityPredicate filter;

        public Config() {
        }

        public Config(EntityPredicate filter) {
            this.filter = filter;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.ENTITY_PREDICATE.writeBits(this.filter, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.filter = Adapters.ENTITY_PREDICATE.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.ENTITY_PREDICATE.writeNbt(this.filter).ifPresent(value -> nbt.m_128365_("filter", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.filter = Adapters.ENTITY_PREDICATE.readNbt(nbt.m_128423_("filter")).orElse(EntityPredicate.FALSE);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.ENTITY_PREDICATE.writeJson(this.filter).ifPresent(value -> json.add("filter", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.filter = Adapters.ENTITY_PREDICATE.readJson(json.get("filter")).orElse(EntityPredicate.FALSE);
        }
    }
}

