/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.data.entity.PartialCompoundNbt;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.core.world.data.tile.PartialBlockState;
import iskallia.vault.core.world.data.tile.PartialTile;
import iskallia.vault.core.world.data.tile.TilePredicate;
import iskallia.vault.task.ConfiguredTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LootChestItemTask
extends ProgressConfiguredTask<Integer, Config> {
    public LootChestItemTask() {
        super(new Config(), TaskCounter.Adapter.INT);
    }

    public LootChestItemTask(Config config, TaskCounter<Integer, ?> counter) {
        super(config, counter, TaskCounter.Adapter.INT);
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.CHEST_LOOT_GENERATION.register(this, data -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            if (data.getPlayer().m_183503_().m_5776_()) {
                return;
            }
            TaskSource patt1364$temp = context.getSource();
            if (!(patt1364$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt1364$temp;
            if (!entitySource.matches((Entity)data.getPlayer())) {
                return;
            }
            PartialTile tile = PartialTile.of(PartialBlockState.of(data.getState()), PartialCompoundNbt.of((BlockEntity)data.getTileEntity()));
            if (!((Config)this.getConfig()).chestFilter.test(tile)) {
                return;
            }
            for (ItemStack stack : data.getLoot()) {
                if (!((Config)this.getConfig()).itemFilter.test(stack)) continue;
                this.counter.onAdd(stack.m_41613_(), context);
            }
        });
        super.onAttach(context);
    }

    public static class Config
    extends ConfiguredTask.Config {
        public TilePredicate chestFilter;
        public ItemPredicate itemFilter;

        public Config() {
        }

        public Config(TilePredicate chestFilter, ItemPredicate itemFilter) {
            this.chestFilter = chestFilter;
            this.itemFilter = itemFilter;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.TILE_PREDICATE.writeBits(this.chestFilter, buffer);
            Adapters.ITEM_PREDICATE.writeBits(this.itemFilter, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.chestFilter = Adapters.TILE_PREDICATE.readBits(buffer).orElseThrow();
            this.itemFilter = Adapters.ITEM_PREDICATE.readBits(buffer).orElseThrow();
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.TILE_PREDICATE.writeNbt(this.chestFilter).ifPresent(value -> nbt.m_128365_("chestFilter", value));
                Adapters.ITEM_PREDICATE.writeNbt(this.itemFilter).ifPresent(value -> nbt.m_128365_("itemFilter", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.chestFilter = Adapters.TILE_PREDICATE.readNbt(nbt.m_128423_("chestFilter")).orElse(TilePredicate.FALSE);
            this.itemFilter = Adapters.ITEM_PREDICATE.readNbt(nbt.m_128423_("itemFilter")).orElse(ItemPredicate.FALSE);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.TILE_PREDICATE.writeJson(this.chestFilter).ifPresent(value -> json.add("chestFilter", value));
                Adapters.ITEM_PREDICATE.writeJson(this.itemFilter).ifPresent(value -> json.add("itemFilter", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.chestFilter = Adapters.TILE_PREDICATE.readJson(json.get("chestFilter")).orElse(TilePredicate.FALSE);
            this.itemFilter = Adapters.ITEM_PREDICATE.readJson(json.get("itemFilter")).orElse(ItemPredicate.FALSE);
        }
    }
}

