/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.task.util.VaultListenerMode;
import iskallia.vault.world.data.ServerVaults;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class MultiVaultTask
extends NodeTask {
    private VaultListenerMode mode;
    private TaskContext vaultContext;
    public static final EnumAdapter<VaultListenerMode> MODE = Adapters.ofEnum(VaultListenerMode.class, EnumAdapter.Mode.NAME);

    public MultiVaultTask() {
    }

    public MultiVaultTask(VaultListenerMode mode) {
        this.mode = mode;
    }

    @Override
    public boolean isCompleted() {
        for (Task task : this.getChildren()) {
            if (task.streamSelfAndDescendants().allMatch(Task::isCompleted)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasActiveChildren() {
        return this.parent == null || this.parent.hasActiveChildren();
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.register(this, data -> {
            TaskSource patt1549$temp = context.getSource();
            if (!(patt1549$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource originalSource = (EntityTaskSource)patt1549$temp;
            this.vaultContext.setServer(context.getServer());
            this.vaultContext.setVault(context.getVault());
            this.vaultContext.setSource((TaskSource)context.getSource().copy());
            TaskSource patt1839$temp = this.vaultContext.getSource();
            if (patt1839$temp instanceof EntityTaskSource) {
                EntityTaskSource newSource = (EntityTaskSource)patt1839$temp;
                newSource.getUuids().clear();
                for (ServerPlayer player : originalSource.getEntities(context.getServer(), ServerPlayer.class)) {
                    UUID owner;
                    UUIDList leavers;
                    Vault vault = ServerVaults.get((Level)player.m_183503_()).orElse(null);
                    if (vault == null || !vault.get(Vault.LISTENERS).contains(player.m_142081_()) || (this.mode == VaultListenerMode.SOLO ? vault.get(Vault.LISTENERS).getAll().size() > 1 || !(leavers = vault.get(Vault.LISTENERS).get(Listeners.LOGIC).getOptional(ClassicListenersLogic.LEAVERS).orElse(UUIDList.create())).isEmpty() : this.mode == VaultListenerMode.OWNER && ((owner = vault.get(Vault.OWNER)) == null || !originalSource.matches(owner)))) continue;
                    newSource.getUuids().add(player.m_142081_());
                }
            }
        });
        if (this.vaultContext == null) {
            this.vaultContext = context.copy();
            TaskSource taskSource = this.vaultContext.getSource();
            if (taskSource instanceof EntityTaskSource) {
                EntityTaskSource source = (EntityTaskSource)taskSource;
                source.getUuids().clear();
            }
        }
        for (Task child : this.children) {
            child.onAttach(this.vaultContext);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        MODE.writeBits(this.mode, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.mode = MODE.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            MODE.writeNbt(this.mode).ifPresent(value -> nbt.m_128365_("mode", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.mode = MODE.readNbt(nbt.m_128423_("mode")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            MODE.writeJson(this.mode).ifPresent(value -> json.add("mode", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.mode = MODE.readJson(json.get("mode")).orElse(VaultListenerMode.ALL);
    }
}

