/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.array.ArrayAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;

public abstract class NodeTask
extends Task {
    protected List<Task> children = new ArrayList<Task>();
    protected static final ArrayAdapter<Task> CHILDREN = Adapters.ofArray(Task[]::new, Adapters.TASK);

    @Override
    public Iterable<Task> getChildren() {
        return this.children;
    }

    public <P extends Task, C extends Task> P setChildren(C ... children) {
        this.children.clear();
        this.addChildren((Task[])children);
        return (P)this;
    }

    public <P extends Task, C extends Task> P setChildren(List<C> children) {
        this.children.clear();
        this.addChildren(children);
        return (P)this;
    }

    public <P extends Task, C extends Task> P addChildren(C ... children) {
        this.addChildren(Arrays.asList(children));
        return (P)this;
    }

    public <P extends Task, C extends Task> P addChildren(List<C> children) {
        for (Task child : children) {
            this.children.add(child);
            child.parent = this;
        }
        return (P)this;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        CHILDREN.writeBits((Task)((Task[])this.children.toArray(Task[]::new)), buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.setChildren((Task[])CHILDREN.readBits(buffer).orElseThrow());
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            CHILDREN.writeNbt((Task)((Task[])this.children.toArray(Task[]::new))).ifPresent(value -> nbt.m_128365_("children", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.setChildren(CHILDREN.readNbt(nbt.m_128423_("children")).orElse(new Task[0]));
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            CHILDREN.writeJson((Task)((Task[])this.children.toArray(Task[]::new))).ifPresent(value -> json.add("children", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.setChildren(CHILDREN.readJson(json.get("children")).orElse(new Task[0]));
    }
}

