/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.RepeatingTask;
import iskallia.vault.task.ResettingTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PlayerDividedTask
extends NodeTask
implements ResettingTask,
RepeatingTask {
    private final Map<UUID, List<Task>> tasks = new HashMap<UUID, List<Task>>();

    @Override
    public Iterable<Task> getChildren() {
        return new ArrayList<Task>();
    }

    @Override
    public boolean isCompleted() {
        return this.tasks.values().stream().anyMatch(tasks -> {
            for (Task task : tasks) {
                if (task.streamSelfAndDescendants().allMatch(Task::isCompleted)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public boolean hasActiveChildren() {
        return this.parent == null || this.parent.hasActiveChildren();
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.register(this, event -> {
            TaskSource patt1263$temp = context.getSource();
            if (patt1263$temp instanceof EntityTaskSource) {
                EntityTaskSource source = (EntityTaskSource)patt1263$temp;
                for (UUID uuid : source.getUuids()) {
                    if (this.tasks.containsKey(uuid)) continue;
                    TaskContext newContext = this.newContext(context, uuid);
                    ArrayList<Task> tasks = new ArrayList<Task>();
                    for (Task task : this.children) {
                        task = task.copy();
                        task.parent = this;
                        tasks.add(task);
                        task.onAttach(newContext);
                    }
                    this.tasks.put(uuid, tasks);
                }
                this.tasks.entrySet().removeIf(entry -> {
                    UUID uuid = (UUID)entry.getKey();
                    List tasks = (List)entry.getValue();
                    if (source.getUuids().contains(uuid)) {
                        return false;
                    }
                    for (Task task : tasks) {
                        task.onDetach();
                    }
                    return true;
                });
            }
        });
        this.tasks.forEach((uuid, tasks) -> {
            TaskContext newContext = this.newContext(context, (UUID)uuid);
            for (Task task : tasks) {
                task.onAttach(newContext);
            }
        });
    }

    @Override
    public void onDetach() {
        this.tasks.forEach((uuid, tasks) -> {
            for (Task task : tasks) {
                task.onDetach();
            }
        });
        super.onDetach();
    }

    @Override
    public void onReset(TaskContext context) {
        this.tasks.entrySet().removeIf(entry -> {
            for (Task task : (List)entry.getValue()) {
                task.onDetach();
            }
            return true;
        });
    }

    @Override
    public void onRepeat(TaskContext context) {
        Iterator<Map.Entry<UUID, List<Task>>> it = this.tasks.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry<UUID, List<Task>> entry = it.next();
            for (Task task : entry.getValue()) {
                if (task.streamSelfAndDescendants().allMatch(Task::isCompleted)) continue;
                continue block0;
            }
            for (Task child : entry.getValue()) {
                child.onDetach();
            }
            it.remove();
            break;
        }
    }

    public TaskContext newContext(TaskContext context, UUID uuid) {
        TaskContext copy = context.copy();
        TaskSource taskSource = copy.getSource();
        if (taskSource instanceof EntityTaskSource) {
            EntityTaskSource source = (EntityTaskSource)taskSource;
            source.getUuids().clear();
            source.getUuids().add(uuid);
        }
        return copy;
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.tasks.size(), buffer);
        this.tasks.forEach((uuid, tasks) -> {
            Adapters.UUID.writeBits((UUID)uuid, buffer);
            CHILDREN.writeBits((Task[])tasks.toArray(Task[]::new), buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        int size = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.tasks.clear();
        for (int i = 0; i < size; ++i) {
            UUID uuid = Adapters.UUID.readBits(buffer).orElseThrow();
            ArrayList<Task> tasks = new ArrayList<Task>(Arrays.asList((Task[])CHILDREN.readBits(buffer).orElseThrow()));
            tasks.forEach(task -> {
                task.parent = this;
            });
            this.tasks.put(uuid, tasks);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            CompoundTag tasksTag = new CompoundTag();
            this.tasks.forEach((uuid, tasks) -> CHILDREN.writeNbt((Task[])tasks.toArray(Task[]::new)).ifPresent(tag -> tasksTag.m_128365_(uuid.toString(), tag)));
            nbt.m_128365_("tasks", (Tag)tasksTag);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.tasks.clear();
        CompoundTag tasksTag = nbt.m_128469_("tasks");
        for (String key : tasksTag.m_128431_()) {
            ArrayList<Task> tasks = new ArrayList<Task>(Arrays.asList(CHILDREN.readNbt(tasksTag.m_128423_(key)).orElse(new Task[0])));
            tasks.forEach(task -> {
                task.parent = this;
            });
            this.tasks.put(UUID.fromString(key), tasks);
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            JsonObject tasksTag = new JsonObject();
            this.tasks.forEach((uuid, tasks) -> CHILDREN.writeJson((Task[])tasks.toArray(Task[]::new)).ifPresent(tag -> tasksTag.add(uuid.toString(), tag)));
            json.add("tasks", (JsonElement)tasksTag);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.tasks.clear();
        JsonElement jsonElement = json.get("tasks");
        if (jsonElement instanceof JsonObject) {
            JsonObject tasksTag = (JsonObject)jsonElement;
            for (String key : tasksTag.keySet()) {
                ArrayList<Task> tasks = new ArrayList<Task>(Arrays.asList(CHILDREN.readJson(tasksTag.get(key)).orElse(new Task[0])));
                tasks.forEach(task -> {
                    task.parent = this;
                });
                this.tasks.put(UUID.fromString(key), tasks);
            }
        }
    }
}

