/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;

public class PlayerVaultLevelTask
extends NodeTask {
    private int minimumLevel;
    private boolean completed;

    public int getMinimumLevel() {
        return this.minimumLevel;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.register(this, event -> {
            this.completed = true;
            TaskSource patt989$temp = context.getSource();
            if (!(patt989$temp instanceof EntityTaskSource)) {
                return;
            }
            EntityTaskSource entitySource = (EntityTaskSource)patt989$temp;
            for (Player player : entitySource.getEntities(Player.class)) {
                PlayerVaultStats stats = PlayerVaultStatsData.get(context.getServer()).getVaultStats(player);
                if (stats.getVaultLevel() >= this.minimumLevel) continue;
                this.completed = false;
                break;
            }
        });
        super.onAttach(context);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.INT_SEGMENTED_7.writeBits(this.minimumLevel, buffer);
        Adapters.BOOLEAN.writeBits(this.completed, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.minimumLevel = (Integer)Adapters.INT_SEGMENTED_7.readBits(buffer).orElseThrow();
        this.completed = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.INT.writeNbt(this.minimumLevel).ifPresent(value -> nbt.m_128365_("minimumLevel", value));
            Adapters.BOOLEAN.writeNbt(this.completed).ifPresent(value -> nbt.m_128365_("completed", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.minimumLevel = Adapters.INT.readNbt(nbt.m_128423_("minimumLevel")).orElse(0);
        this.completed = Adapters.BOOLEAN.readNbt(nbt.m_128423_("completed")).orElse(false);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.INT.writeJson(this.minimumLevel).ifPresent(value -> json.add("minimumLevel", value));
            Adapters.BOOLEAN.writeJson(this.completed).ifPresent(value -> json.add("completed", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.minimumLevel = Adapters.INT.readJson(json.get("minimumLevel")).orElse(0);
        this.completed = Adapters.BOOLEAN.readJson(json.get("completed")).orElse(false);
    }
}

