/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.basic.EnumAdapter;
import iskallia.vault.core.data.compound.UUIDList;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.player.ClassicListenersLogic;
import iskallia.vault.core.vault.player.Listeners;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.RepeatingTask;
import iskallia.vault.task.ResettingTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.source.EntityTaskSource;
import iskallia.vault.task.source.TaskSource;
import iskallia.vault.task.util.VaultListenerMode;
import iskallia.vault.world.data.ServerVaults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class SingleVaultTask
extends NodeTask
implements ResettingTask,
RepeatingTask {
    private VaultListenerMode mode;
    private final Map<UUID, VaultHolder> vaultHolders;
    public static final EnumAdapter<VaultListenerMode> MODE = Adapters.ofEnum(VaultListenerMode.class, EnumAdapter.Mode.NAME);

    public SingleVaultTask() {
        this.vaultHolders = new HashMap<UUID, VaultHolder>();
    }

    public SingleVaultTask(VaultListenerMode mode) {
        this.mode = mode;
        this.vaultHolders = new HashMap<UUID, VaultHolder>();
    }

    @Override
    public Iterable<Task> getChildren() {
        return new ArrayList<Task>();
    }

    @Override
    public boolean isCompleted() {
        return this.vaultHolders.values().stream().anyMatch(holder -> {
            EntityTaskSource entityTaskSource;
            TaskSource patt1478$temp = holder.context.getSource();
            if (patt1478$temp instanceof EntityTaskSource && (entityTaskSource = (EntityTaskSource)patt1478$temp).getCount() == 0) {
                return false;
            }
            for (Task task : holder.getChildren()) {
                if (task.streamSelfAndDescendants().allMatch(Task::isCompleted)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public boolean hasActiveChildren() {
        return this.parent == null || this.parent.hasActiveChildren();
    }

    public VaultHolder getOrCreateHolder(TaskContext context, UUID vaultId) {
        return this.vaultHolders.computeIfAbsent(vaultId, uuid -> {
            TaskContext newContext = context.copy();
            TaskSource patt2224$temp = newContext.getSource();
            if (patt2224$temp instanceof EntityTaskSource) {
                EntityTaskSource source = (EntityTaskSource)patt2224$temp;
                source.getUuids().clear();
            }
            VaultHolder holder = new VaultHolder(this, newContext);
            for (Task child : this.children) {
                Object copy = child.copy();
                ((Task)copy).parent = this;
                holder.getChildren().add((Task)copy);
                ((Task)copy).onAttach(newContext);
            }
            return holder;
        });
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.register(this, data -> {
            block8: {
                Vault vault;
                EntityTaskSource source;
                block7: {
                    TaskSource patt2822$temp = context.getSource();
                    if (!(patt2822$temp instanceof EntityTaskSource)) {
                        return;
                    }
                    source = (EntityTaskSource)patt2822$temp;
                    for (Map.Entry<UUID, VaultHolder> entry2 : this.vaultHolders.entrySet()) {
                        entry2.getValue().getContext().setServer(context.getServer());
                        entry2.getValue().getContext().setVault(ServerVaults.get(entry2.getKey()).orElse(null));
                        entry2.getValue().getUuids().clear();
                    }
                    for (ServerPlayer player : source.getEntities(context.getServer(), ServerPlayer.class)) {
                        vault = ServerVaults.get(player.f_19853_).orElse(null);
                        if (vault == null || !vault.get(Vault.LISTENERS).contains(player.m_142081_())) continue;
                        VaultHolder holder = this.getOrCreateHolder(context, vault.get(Vault.ID));
                        holder.getUuids().add(player.m_142081_());
                    }
                    this.vaultHolders.entrySet().removeIf(entry -> {
                        if (ServerVaults.get((UUID)entry.getKey()).isEmpty()) {
                            for (Task child : ((VaultHolder)entry.getValue()).getChildren()) {
                                child.onDetach();
                            }
                            return true;
                        }
                        return false;
                    });
                    if (this.mode != VaultListenerMode.SOLO) break block7;
                    for (Map.Entry<UUID, VaultHolder> entry2 : this.vaultHolders.entrySet()) {
                        vault = ServerVaults.get(entry2.getKey()).orElse(null);
                        if (vault == null) {
                            throw new IllegalStateException("This is literally impossible");
                        }
                        UUIDList leavers = vault.get(Vault.LISTENERS).get(Listeners.LOGIC).getOptional(ClassicListenersLogic.LEAVERS).orElse(UUIDList.create());
                        if (entry2.getValue().getUuids().size() <= 1 && leavers.isEmpty()) continue;
                        entry2.getValue().getUuids().clear();
                    }
                    break block8;
                }
                if (this.mode != VaultListenerMode.OWNER) break block8;
                for (Map.Entry<UUID, VaultHolder> entry2 : this.vaultHolders.entrySet()) {
                    vault = ServerVaults.get(entry2.getKey()).orElse(null);
                    if (vault == null) {
                        throw new IllegalStateException("This is literally impossible");
                    }
                    UUID owner = vault.get(Vault.OWNER);
                    if (owner != null && source.matches(owner)) continue;
                    entry2.getValue().getUuids().clear();
                }
            }
        });
        this.vaultHolders.forEach((key, holder) -> {
            for (Task child : holder.children) {
                child.onAttach(holder.getContext());
            }
        });
    }

    @Override
    public void onDetach() {
        this.vaultHolders.forEach((key, holder) -> {
            for (Task child : holder.children) {
                child.onDetach();
            }
        });
        super.onDetach();
    }

    @Override
    public void onReset(TaskContext context) {
        this.vaultHolders.entrySet().removeIf(entry -> {
            for (Task task : ((VaultHolder)entry.getValue()).getChildren()) {
                task.onDetach();
            }
            return true;
        });
    }

    @Override
    public void onRepeat(TaskContext context) {
        Iterator<Map.Entry<UUID, VaultHolder>> it = this.vaultHolders.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry<UUID, VaultHolder> entry = it.next();
            for (Task task : entry.getValue().getChildren()) {
                if (task.streamSelfAndDescendants().allMatch(Task::isCompleted)) continue;
                continue block0;
            }
            for (Task child : entry.getValue().getChildren()) {
                child.onDetach();
            }
            it.remove();
            break;
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        MODE.writeBits(this.mode, buffer);
        Adapters.INT_SEGMENTED_3.writeBits(this.vaultHolders.size(), buffer);
        this.vaultHolders.forEach((uuid, holder) -> {
            Adapters.UUID.writeBits((UUID)uuid, buffer);
            holder.writeBits(buffer);
        });
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.mode = MODE.readBits(buffer).orElseThrow();
        int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
        this.vaultHolders.clear();
        for (int i = 0; i < size; ++i) {
            UUID uuid = Adapters.UUID.readBits(buffer).orElseThrow();
            VaultHolder holder = new VaultHolder(this, new TaskContext());
            holder.readBits(buffer);
            this.vaultHolders.put(uuid, holder);
        }
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            MODE.writeNbt(this.mode).ifPresent(value -> nbt.m_128365_("mode", value));
            CompoundTag holders = new CompoundTag();
            this.vaultHolders.forEach((uuid, holder) -> holder.writeNbt().ifPresent(tag -> holders.m_128365_(uuid.toString(), (Tag)tag)));
            nbt.m_128365_("holders", (Tag)holders);
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.mode = MODE.readNbt(nbt.m_128423_("mode")).orElseThrow();
        CompoundTag holders = nbt.m_128469_("holders");
        this.vaultHolders.clear();
        for (String key : holders.m_128431_()) {
            VaultHolder holder = new VaultHolder(this, new TaskContext());
            holder.readNbt(holders.m_128469_(key));
            this.vaultHolders.put(UUID.fromString(key), holder);
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            MODE.writeJson(this.mode).ifPresent(value -> json.add("mode", value));
            JsonObject holders = new JsonObject();
            this.vaultHolders.forEach((uuid, holder) -> holder.writeJson().ifPresent(tag -> holders.add(uuid.toString(), (JsonElement)tag)));
            holders.add("holders", (JsonElement)holders);
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.mode = MODE.readJson(json.get("mode")).orElse(VaultListenerMode.ALL);
        this.vaultHolders.clear();
        JsonElement jsonElement = json.get("holders");
        if (jsonElement instanceof JsonObject) {
            JsonObject holders = (JsonObject)jsonElement;
            for (String key : holders.keySet()) {
                VaultHolder holder = new VaultHolder(this, new TaskContext());
                holder.readJson(holders.getAsJsonObject(key));
                this.vaultHolders.put(UUID.fromString(key), holder);
            }
        }
    }

    public static class VaultHolder
    implements ISerializable<CompoundTag, JsonObject> {
        private Task parent;
        private final TaskContext context;
        private List<Task> children;

        public VaultHolder(Task parent, TaskContext context) {
            this.context = context;
            this.children = new ArrayList<Task>();
        }

        public TaskContext getContext() {
            return this.context;
        }

        public Set<UUID> getUuids() {
            TaskSource taskSource = this.context.getSource();
            if (taskSource instanceof EntityTaskSource) {
                EntityTaskSource source = (EntityTaskSource)taskSource;
                return source.getUuids();
            }
            return new HashSet<UUID>();
        }

        public List<Task> getChildren() {
            return this.children;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.TASK_SOURCE.writeBits(this.context.getSource(), buffer);
            Adapters.INT_SEGMENTED_3.writeBits(this.children.size(), buffer);
            for (Task child : this.children) {
                Adapters.TASK.writeBits(child, buffer);
            }
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.context.setSource((TaskSource)Adapters.TASK_SOURCE.readBits(buffer).orElseThrow());
            this.children.clear();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < size; ++i) {
                Task task = (Task)Adapters.TASK.readBits(buffer).orElseThrow();
                task.parent = this.parent;
                this.children.add(task);
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                Adapters.TASK_SOURCE.writeNbt(this.context.getSource()).ifPresent(tag -> nbt.m_128365_("source", tag));
                NodeTask.CHILDREN.writeNbt((Task)((Task[])this.children.toArray(Task[]::new))).ifPresent(tag -> nbt.m_128365_("children", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.context.setSource((TaskSource)Adapters.TASK_SOURCE.readNbt(nbt.m_128423_("source")).orElseThrow());
            this.children = Arrays.stream(NodeTask.CHILDREN.readNbt(nbt.m_128423_("children")).orElse(new Task[0])).collect(Collectors.toList());
            this.children.forEach(task -> {
                task.parent = this.parent;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                Adapters.TASK_SOURCE.writeJson(this.context.getSource()).ifPresent(tag -> json.add("source", tag));
                NodeTask.CHILDREN.writeJson((Task)((Task[])this.children.toArray(Task[]::new))).ifPresent(tag -> json.add("children", tag));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.context.setSource((TaskSource)Adapters.TASK_SOURCE.readJson(json.get("source")).orElseThrow());
            this.children = Arrays.stream(NodeTask.CHILDREN.readJson(json.get("children")).orElse(new Task[0])).collect(Collectors.toList());
            this.children.forEach(task -> {
                task.parent = this.parent;
            });
        }
    }
}

