/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.AchievementCompleteTask;
import iskallia.vault.task.AchievementTask;
import iskallia.vault.task.AddVaultModifierTask;
import iskallia.vault.task.BingoObjectiveTask;
import iskallia.vault.task.BingoTask;
import iskallia.vault.task.CakeObjectiveTask;
import iskallia.vault.task.CollectionTask;
import iskallia.vault.task.CraftingTask;
import iskallia.vault.task.DealDamageTask;
import iskallia.vault.task.DealNoDamageTask;
import iskallia.vault.task.DiscoverTransmogTask;
import iskallia.vault.task.FindVaultRoomTask;
import iskallia.vault.task.FinishVaultTask;
import iskallia.vault.task.GodAltarTask;
import iskallia.vault.task.GreedTask;
import iskallia.vault.task.InteractBlockTask;
import iskallia.vault.task.ItemRewardTask;
import iskallia.vault.task.ItemStatTask;
import iskallia.vault.task.KillEntityTask;
import iskallia.vault.task.LootChestItemTask;
import iskallia.vault.task.LootChestTask;
import iskallia.vault.task.MineBlockTask;
import iskallia.vault.task.MultiVaultTask;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.PlayerDividedTask;
import iskallia.vault.task.PlayerVaultLevelTask;
import iskallia.vault.task.RepeatedTask;
import iskallia.vault.task.SingleVaultTask;
import iskallia.vault.task.TakeDamageTask;
import iskallia.vault.task.TakeNoDamageTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.TimedTask;
import iskallia.vault.task.UseNoManaTask;
import iskallia.vault.task.VaultTimedTask;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.context.RendererContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Task
implements ISerializable<CompoundTag, JsonObject> {
    protected String id;
    protected Task parent;
    protected TaskRenderer<?, ?> renderer;

    @Nullable
    public String getId() {
        return this.id;
    }

    public <T extends Task> T setId(String id) {
        this.id = id;
        return (T)this;
    }

    public Task getParent() {
        return this.parent;
    }

    public void setParent(Task parent) {
        this.parent = parent;
    }

    public abstract Iterable<Task> getChildren();

    public Iterable<Task> getSelfAndChildren() {
        return Iterables.concat(Collections.singleton(this), this.getChildren());
    }

    public <T> Iterable<T> getChildren(Class<T> type) {
        return Iterables.filter(this.getChildren(), type);
    }

    public <T> Iterable<T> getSelfAndChildren(Class<T> type) {
        return Iterables.filter(this.getSelfAndChildren(), type);
    }

    public Stream<Task> streamChildren() {
        return Streams.stream(this.getChildren());
    }

    public Stream<Task> streamSelfAndChildren() {
        return Streams.stream(this.getSelfAndChildren());
    }

    public <T> Stream<T> streamChildren(Class<T> type) {
        return Streams.stream(this.getChildren(type));
    }

    public <T> Stream<T> streamSelfAndChildren(Class<T> type) {
        return Streams.stream(this.getSelfAndChildren(type));
    }

    public Iterable<Task> getDescendants() {
        ArrayList<Task> flattened = new ArrayList<Task>();
        for (Task child : this.getChildren()) {
            flattened.add(child);
            child.getDescendants().forEach(flattened::add);
        }
        return flattened;
    }

    public Iterable<Task> getSelfAndDescendants() {
        return Iterables.concat(Collections.singleton(this), this.getDescendants());
    }

    public <T> Iterable<T> getDescendants(Class<T> type) {
        return Iterables.filter(this.getDescendants(), type);
    }

    public <T> Iterable<T> getSelfAndDescendants(Class<T> type) {
        return Iterables.filter(this.getSelfAndDescendants(), type);
    }

    public Stream<Task> streamDescendants() {
        return Streams.stream(this.getDescendants());
    }

    public Stream<Task> streamSelfAndDescendants() {
        return Streams.stream(this.getSelfAndDescendants());
    }

    public <T> Stream<T> streamDescendants(Class<T> type) {
        return Streams.stream(this.getDescendants(type));
    }

    public <T> Stream<T> streamSelfAndDescendants(Class<T> type) {
        return Streams.stream(this.getSelfAndDescendants(type));
    }

    public <T extends Task, C extends RendererContext> TaskRenderer<T, C> getRenderer() {
        return this.renderer != null ? this.renderer : TaskRenderer.PASS;
    }

    public <T extends Task, C extends RendererContext> T setRenderer(TaskRenderer<T, C> renderer) {
        this.renderer = renderer;
        return (T)this;
    }

    public abstract boolean isCompleted();

    public boolean hasActiveChildren() {
        return this.isCompleted() && (this.parent == null || this.parent.hasActiveChildren());
    }

    public void onAttach(TaskContext context) {
        this.getChildren().forEach(task -> task.onAttach(context));
    }

    public void onDetach() {
        CommonEvents.release(this);
        this.getChildren().forEach(Task::onDetach);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onRender(RendererContext context) {
        this.getRenderer().onRender(this, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onMouseMoved(RendererContext context) {
        this.getRenderer().onMouseMoved(this, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseClicked(int button, RendererContext context) {
        return this.getRenderer().onMouseClicked(this, button, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseReleased(int button, RendererContext context) {
        return this.getRenderer().onMouseReleased(this, button, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseDragged(int button, double dragX, double dragY, RendererContext context) {
        return this.getRenderer().onMouseDragged(this, button, dragX, dragY, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onMouseScrolled(double delta, RendererContext context) {
        return this.getRenderer().onMouseScrolled(this, delta, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onKeyPressed(int keyCode, int scanCode, int modifiers, RendererContext context) {
        return this.getRenderer().onKeyPressed(this, keyCode, scanCode, modifiers, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onKeyReleased(int keyCode, int scanCode, int modifiers, RendererContext context) {
        return this.getRenderer().onKeyReleased(this, keyCode, scanCode, modifiers, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onCharTyped(char codePoint, int modifiers, RendererContext context) {
        return this.getRenderer().onCharTyped(this, codePoint, modifiers, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onChangeFocus(boolean focus, RendererContext context) {
        return this.getRenderer().onChangeFocus(this, focus, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isMouseOver(RendererContext context) {
        return this.getRenderer().isMouseOver(this, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onUpdateNarration(NarrationElementOutput output, RendererContext context) {
        this.getRenderer().onUpdateNarration(this, output, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public NarratableEntry.NarrationPriority getNarrationPriority(RendererContext context) {
        return this.getRenderer().getNarrationPriority(this, context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isActive(RendererContext context) {
        return this.getRenderer().isActive(this, context);
    }

    public <T extends Task> T copy() {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        Adapters.TASK.writeBits(this, (BitBuffer)buffer);
        buffer.setPosition(0);
        return (T)((Task)Adapters.TASK.readBits(buffer).orElseThrow());
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        Adapters.UTF_8.asNullable().writeBits(this.id, buffer);
        Adapters.TASK_RENDERER.get(this).writeBits(this.renderer, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        this.id = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
        this.renderer = Adapters.TASK_RENDERER.get(this).readBits(buffer).orElse(null);
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        CompoundTag nbt = new CompoundTag();
        Adapters.UTF_8.asNullable().writeNbt(this.id).ifPresent(value -> nbt.m_128365_("id", value));
        Adapters.TASK_RENDERER.get(this).writeNbt(this.renderer).ifPresent(value -> nbt.m_128365_("renderer", value));
        return Optional.of(nbt);
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        this.id = Adapters.UTF_8.asNullable().readNbt(nbt.m_128423_("id")).orElse(null);
        this.renderer = Adapters.TASK_RENDERER.get(this).readNbt(nbt.m_128423_("renderer")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        JsonObject json = new JsonObject();
        Adapters.UTF_8.asNullable().writeJson(this.id).ifPresent(value -> json.add("id", value));
        Adapters.TASK_RENDERER.get(this).writeJson(this.renderer).ifPresent(value -> json.add("renderer", value));
        return Optional.of(json);
    }

    @Override
    public void readJson(JsonObject json) {
        this.id = Adapters.UTF_8.asNullable().readJson(json.get("id")).orElse(null);
        this.renderer = Adapters.TASK_RENDERER.get(this).readJson(json.get("renderer")).orElse(null);
    }

    public static class Adapter
    extends TypeSupplierAdapter<Task> {
        public Adapter() {
            super("type", false);
            this.register("timed", TimedTask.class, TimedTask::new);
            this.register("repeated", RepeatedTask.class, RepeatedTask::new);
            this.register("single_vault", SingleVaultTask.class, SingleVaultTask::new);
            this.register("multi_vault", MultiVaultTask.class, MultiVaultTask::new);
            this.register("player_divided", PlayerDividedTask.class, PlayerDividedTask::new);
            this.register("achievement", AchievementTask.class, AchievementTask::new);
            this.register("finish_vault", FinishVaultTask.class, FinishVaultTask::new);
            this.register("bingo", BingoTask.class, BingoTask::new);
            this.register("god_altar", GodAltarTask.class, GodAltarTask::new);
            this.register("greed", GreedTask.class, GreedTask::new);
            this.register("kill_entity", KillEntityTask.class, KillEntityTask::new);
            this.register("loot_chest", LootChestTask.class, LootChestTask::new);
            this.register("loot_chest_item", LootChestItemTask.class, LootChestItemTask::new);
            this.register("mine_block", MineBlockTask.class, MineBlockTask::new);
            this.register("interact_block", InteractBlockTask.class, InteractBlockTask::new);
            this.register("crafting", CraftingTask.class, CraftingTask::new);
            this.register("item_stat", ItemStatTask.class, ItemStatTask::new);
            this.register("transmog_reward", DiscoverTransmogTask.class, DiscoverTransmogTask::new);
            this.register("item_reward", ItemRewardTask.class, ItemRewardTask::new);
            this.register("achievement_complete", AchievementCompleteTask.class, AchievementCompleteTask::new);
            this.register("player_vault_level", PlayerVaultLevelTask.class, PlayerVaultLevelTask::new);
            this.register("add_vault_modifier", AddVaultModifierTask.class, AddVaultModifierTask::new);
            this.register("take_no_damage", TakeNoDamageTask.class, TakeNoDamageTask::new);
            this.register("deal_no_damage", DealNoDamageTask.class, DealNoDamageTask::new);
            this.register("use_no_mana", UseNoManaTask.class, UseNoManaTask::new);
            this.register("find_vault_room", FindVaultRoomTask.class, FindVaultRoomTask::new);
            this.register("deal_damage", DealDamageTask.class, DealDamageTask::new);
            this.register("take_damage", TakeDamageTask.class, TakeDamageTask::new);
            this.register("collection", CollectionTask.class, CollectionTask::new);
            this.register("cake_objective", CakeObjectiveTask.class, CakeObjectiveTask::new);
            this.register("bingo_objective", BingoObjectiveTask.class, BingoObjectiveTask::new);
            this.register("vault_timed", VaultTimedTask.class, VaultTimedTask::new);
        }

        @Override
        @Nullable
        protected Task readSuppliedJson(JsonElement json) {
            JsonObject object;
            String type;
            String[] types;
            if (json instanceof JsonObject && (types = (type = (object = (JsonObject)json).get(this.key).getAsString()).split(Pattern.quote("/"))).length > 1) {
                Task root = null;
                Task leaf = null;
                for (int i = 0; i < types.length; ++i) {
                    String t = types[i];
                    Task other = (Task)this.getValue(t);
                    if (other == null) continue;
                    other.readJson(object);
                    if (i != types.length - 1) {
                        other.setId(null);
                        other.setRenderer(null);
                    }
                    if (leaf != null) {
                        if (leaf instanceof NodeTask) {
                            NodeTask node = (NodeTask)leaf;
                            node.setChildren(new ArrayList());
                            node.addChildren(new Task[]{other});
                        }
                    } else {
                        root = other;
                    }
                    leaf = other;
                }
                return root;
            }
            return (Task)super.readSuppliedJson(json);
        }
    }

    public static class NbtAdapter
    implements ISimpleAdapter<Task, Tag, JsonElement> {
        @Override
        public void writeBits(@Nullable Task task, BitBuffer buffer) {
            Adapters.GENERIC_NBT.asNullable().writeBits(this.writeNbt(task).orElse(null), buffer);
        }

        @Override
        public Optional<Task> readBits(BitBuffer buffer) {
            return Adapters.GENERIC_NBT.asNullable().readBits(buffer).flatMap(this::readNbt);
        }

        @Override
        public Optional<Tag> writeNbt(@Nullable Task task) {
            return Adapters.TASK.writeNbt(task);
        }

        @Override
        public Optional<Task> readNbt(@Nullable Tag nbt) {
            return Adapters.TASK.readNbt(nbt);
        }

        @Override
        public Optional<JsonElement> writeJson(@Nullable Task task) {
            return Adapters.GENERIC_NBT.asNullable().writeJson(this.writeNbt(task).orElse(null));
        }

        @Override
        public Optional<Task> readJson(@Nullable JsonElement json) {
            return Adapters.GENERIC_NBT.asNullable().readJson(json).flatMap(this::readNbt);
        }
    }
}

