/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.time.TickClock;
import iskallia.vault.task.NodeTask;
import iskallia.vault.task.ResettingTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TaskContext;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.event.TickEvent;

public class VaultTimedTask
extends NodeTask
implements ResettingTask {
    private long elapsed;
    private long duration;

    public VaultTimedTask() {
    }

    public VaultTimedTask(long duration) {
        this.elapsed = 0L;
        this.duration = duration;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public long getDuration() {
        return this.duration;
    }

    @Override
    public boolean isCompleted() {
        return this.elapsed < this.duration;
    }

    @Override
    public void onAttach(TaskContext context) {
        CommonEvents.SERVER_TICK.at(TickEvent.Phase.END).register(this, event -> {
            if (this.parent != null && !this.parent.hasActiveChildren()) {
                return;
            }
            if (context.getVault() == null) {
                return;
            }
            if (context.getVault().get(Vault.CLOCK).has(TickClock.PAUSED)) {
                return;
            }
            this.elapsed = Math.min(this.elapsed + 1L, this.duration);
        });
        super.onAttach(context);
    }

    @Override
    public void onReset(TaskContext context) {
        this.elapsed = 0L;
        for (Task child : this.children) {
            if (!(child instanceof ResettingTask)) continue;
            ResettingTask resettingTask = (ResettingTask)((Object)child);
            resettingTask.onReset(context);
        }
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.LONG_SEGMENTED_15.writeBits(this.elapsed, buffer);
        Adapters.LONG_SEGMENTED_15.writeBits(this.duration, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.elapsed = (Long)Adapters.LONG_SEGMENTED_15.readBits(buffer).orElseThrow();
        this.duration = (Long)Adapters.LONG_SEGMENTED_15.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.LONG_SEGMENTED_15.writeNbt(this.elapsed).ifPresent(value -> nbt.m_128365_("elapsed", value));
            Adapters.LONG_SEGMENTED_15.writeNbt(this.duration).ifPresent(value -> nbt.m_128365_("duration", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.elapsed = Adapters.LONG_SEGMENTED_15.readNbt(nbt.m_128423_("elapsed")).orElse(0L);
        this.duration = (Long)Adapters.LONG_SEGMENTED_15.readNbt(nbt.m_128423_("duration")).orElseThrow();
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.LONG_SEGMENTED_15.writeJson(this.elapsed).ifPresent(value -> json.add("elapsed", value));
            Adapters.LONG_SEGMENTED_15.writeJson(this.duration).ifPresent(value -> json.add("duration", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.elapsed = Adapters.LONG_SEGMENTED_15.readJson(json.get("elapsed")).orElse(0L);
        this.duration = (Long)Adapters.LONG_SEGMENTED_15.readJson(json.get("duration")).orElseThrow();
    }
}

