/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.condition;

import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.list.ListAdapter;
import iskallia.vault.core.data.adapter.number.IntAdapter;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.world.data.item.ItemPredicate;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.condition.TaskCondition;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounter;
import iskallia.vault.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ItemsAvailableCondition
extends TaskCondition<Config> {
    public ItemsAvailableCondition() {
        super(new Config());
    }

    @Override
    public boolean isConditionFulfilled(ProgressConfiguredTask<?, ?> task, TaskContext context) {
        IntRoll intCountTarget;
        Object countTarget;
        List<ItemPredicate> conditions = ((Config)this.getConfig()).getFilter();
        if (conditions.isEmpty()) {
            return true;
        }
        TaskCounter<?, ?> taskCounter = task.getCounter();
        if (!(taskCounter instanceof TargetTaskCounter)) {
            return true;
        }
        TargetTaskCounter taskCounter2 = (TargetTaskCounter)taskCounter;
        Object t = taskCounter2.getTarget();
        if (!(t instanceof Integer)) {
            return true;
        }
        Integer targetItemCount = (Integer)t;
        if (targetItemCount <= 0) {
            return true;
        }
        if (((Config)this.getConfig()).getMinimum().isPresent()) {
            targetItemCount = ((Config)this.getConfig()).getMinimum().get();
        }
        int found = 0;
        Vault vault = context.getVault();
        if (vault == null) {
            return true;
        }
        if (!vault.has(Vault.OWNER)) {
            return false;
        }
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        if (srv == null) {
            return false;
        }
        ServerPlayer player = srv.m_6846_().m_11259_(vault.get(Vault.OWNER));
        if (player == null) {
            return false;
        }
        for (InventoryUtil.ItemAccess access : InventoryUtil.findAllItems((Player)player)) {
            if (!conditions.stream().anyMatch(predicate -> predicate.test(access.getStack())) || (found += access.getStack().m_41613_()) < targetItemCount) continue;
            return true;
        }
        if (found > 0 && (countTarget = ((TargetTaskCounter.Config)taskCounter2.getConfig()).getTarget()) instanceof IntRoll && (intCountTarget = (IntRoll)countTarget).contains(found)) {
            taskCounter2.setTarget(found);
            return true;
        }
        return false;
    }

    public static class Config
    extends TaskCondition.Config {
        private static final ListAdapter<ItemPredicate> ADAPTER = Adapters.ofArrayList(Adapters.ITEM_PREDICATE);
        private static final IntAdapter MIN_ADAPTER = Adapters.INT.asNullable();
        private List<ItemPredicate> filter = new ArrayList<ItemPredicate>();
        private Integer minimum;

        public Optional<Integer> getMinimum() {
            return Optional.ofNullable(this.minimum);
        }

        public void setMinimum(Integer minimum) {
            this.minimum = minimum;
        }

        public List<ItemPredicate> getFilter() {
            return this.filter;
        }

        public void setFilter(List<ItemPredicate> filter) {
            this.filter = filter;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            this.writeNbt().ifPresent(tag -> Adapters.COMPOUND_NBT.writeBits(tag, buffer));
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.readNbt(Adapters.COMPOUND_NBT.readBits(buffer).orElse(new CompoundTag()));
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag tag = new CompoundTag();
            ADAPTER.writeNbt((ItemPredicate)((Object)this.getFilter())).ifPresent(value -> tag.m_128365_("filter", value));
            MIN_ADAPTER.writeNbt(this.minimum).ifPresent(value -> tag.m_128365_("minimum", value));
            return Optional.of(tag);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.setFilter(ADAPTER.readNbt(nbt.m_128423_("filter")).orElse(new ArrayList()));
            this.setMinimum(MIN_ADAPTER.readNbt(nbt.m_128423_("minimum")).orElse(null));
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            ADAPTER.writeJson((ItemPredicate)((Object)this.getFilter())).ifPresent(value -> json.add("filter", value));
            MIN_ADAPTER.writeJson(this.minimum).ifPresent(value -> json.add("minimum", value));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            this.setFilter(ADAPTER.readJson(json.get("filter")).orElse(new ArrayList()));
            this.setMinimum(MIN_ADAPTER.readJson(json.get("minimum")).orElse(null));
        }
    }
}

