/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.counter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.data.adapter.INbtAdapter;
import iskallia.vault.core.data.adapter.ISimpleAdapter;
import iskallia.vault.core.data.adapter.basic.TypeSupplierAdapter;
import iskallia.vault.core.data.serializable.ISerializable;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.core.world.roll.FloatRoll;
import iskallia.vault.core.world.roll.IntRoll;
import iskallia.vault.task.TaskContext;
import iskallia.vault.task.counter.SlidingTimedTargetTaskCounter;
import iskallia.vault.task.counter.TargetTaskCounter;
import iskallia.vault.task.counter.TaskCounterPredicate;
import iskallia.vault.task.util.TaskProgress;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class TaskCounter<T, C extends Config>
implements ISerializable<CompoundTag, JsonObject> {
    private final Group<T> group;
    private C config;
    private boolean populated;

    public TaskCounter(Group<T> group, C config) {
        this.group = group;
        this.config = config;
    }

    public Group<T> getGroup() {
        return this.group;
    }

    public C getConfig() {
        return this.config;
    }

    public <N extends Tag> N get(String name) {
        return (N)((Config)this.config).variables.get(name);
    }

    public <V> Optional<V> get(String name, INbtAdapter<V, ?, ?> adapter) {
        return adapter.readNbt(this.get(name), null);
    }

    public boolean isPopulated() {
        return this.populated;
    }

    public void setPopulated(boolean populated) {
        this.populated = populated;
    }

    public abstract void onPopulate(TaskContext var1);

    public void populate(TaskContext context) {
        if (!this.isPopulated()) {
            this.onPopulate(context);
            this.setPopulated(true);
        }
    }

    public abstract TaskProgress getProgress();

    public void onSet(T value, TaskContext context) {
        this.populate(context);
    }

    public void onAdd(T value, TaskContext context) {
        this.populate(context);
    }

    public void onRemove(T value, TaskContext context) {
        this.populate(context);
    }

    public boolean isCompleted() {
        return this.isPopulated();
    }

    public void onAttach(TaskContext context) {
        this.populate(context);
    }

    public void onReset(TaskContext context) {
        this.populate(context);
    }

    public void onRepeat(TaskContext context) {
        this.populate(context);
    }

    public void onDetach() {
        CommonEvents.release(this);
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        ((Config)this.config).writeBits(buffer);
        Adapters.BOOLEAN.writeBits(this.populated, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        ((Config)this.config).readBits(buffer);
        this.populated = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return Optional.of(new CompoundTag()).map(nbt -> {
            if (!this.populated) {
                CompoundTag other = ((Config)this.config).writeNbt().orElseThrow();
                other.m_128431_().forEach(key -> nbt.m_128365_(key, Objects.requireNonNull(other.m_128423_(key))));
            } else {
                nbt.m_128365_("config", (Tag)((Config)this.config).writeNbt().orElseThrow());
            }
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        if (!nbt.m_128441_("config")) {
            ((Config)this.config).readNbt(nbt);
            this.populated = false;
        } else {
            ((Config)this.config).readNbt(nbt.m_128469_("config"));
            this.populated = true;
        }
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return Optional.of(new JsonObject()).map(json -> {
            if (!this.populated) {
                ((Config)this.config).writeJson().orElseThrow().entrySet().forEach(entry -> json.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            } else {
                json.add("config", (JsonElement)((Config)this.config).writeJson().orElseThrow());
            }
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        if (!json.has("config")) {
            ((Config)this.config).readJson(json);
            this.populated = false;
        } else {
            ((Config)this.config).readJson(json.getAsJsonObject("config"));
            this.populated = true;
        }
    }

    public static TargetTaskCounter<Integer, TargetTaskCounter.Config<Integer, ?>> ofTargetInt() {
        return TaskCounter.ofTargetInt(null, null);
    }

    public static TargetTaskCounter<Integer, TargetTaskCounter.Config<Integer, ?>> ofTargetInt(IntRoll target, TaskCounterPredicate predicate) {
        return new TargetTaskCounter(Group.INT, new TargetTaskCounter.Config<Integer, IntRoll>(target, predicate, Adapters.INT_ROLL, IntRoll::get));
    }

    public static SlidingTimedTargetTaskCounter<Integer, SlidingTimedTargetTaskCounter.Config<Integer, ?>> ofSlidingTargetInt() {
        return TaskCounter.ofSlidingTargetInt(null, null);
    }

    public static SlidingTimedTargetTaskCounter<Integer, SlidingTimedTargetTaskCounter.Config<Integer, ?>> ofSlidingTargetInt(IntRoll target, IntRoll window) {
        return new SlidingTimedTargetTaskCounter(Group.INT, new SlidingTimedTargetTaskCounter.Config<Integer, IntRoll>(target, Adapters.INT_ROLL, IntRoll::get, window));
    }

    public static TargetTaskCounter<Float, TargetTaskCounter.Config<Float, ?>> ofTargetFloat() {
        return TaskCounter.ofTargetFloat(null, null);
    }

    public static TargetTaskCounter<Float, TargetTaskCounter.Config<Float, ?>> ofTargetFloat(FloatRoll target, TaskCounterPredicate predicate) {
        return new TargetTaskCounter(Group.FLOAT, new TargetTaskCounter.Config<Float, FloatRoll>(target, predicate, Adapters.FLOAT_ROLL, FloatRoll::get));
    }

    public static SlidingTimedTargetTaskCounter<Float, SlidingTimedTargetTaskCounter.Config<Float, ?>> ofSlidingTargetFloat() {
        return TaskCounter.ofSlidingTargetFloat(null, null);
    }

    public static SlidingTimedTargetTaskCounter<Float, SlidingTimedTargetTaskCounter.Config<Float, ?>> ofSlidingTargetFloat(FloatRoll target, IntRoll window) {
        return new SlidingTimedTargetTaskCounter(Group.FLOAT, new SlidingTimedTargetTaskCounter.Config<Float, FloatRoll>(target, Adapters.FLOAT_ROLL, FloatRoll::get, window));
    }

    public static class Group<T> {
        public static final Group<Integer> INT = new Group<Integer>(Adapters.INT_SEGMENTED_7, 0, Integer::sum, Integer::compare, i -> -i.intValue());
        public static final Group<Float> FLOAT = new Group<Float>(Adapters.FLOAT, Float.valueOf(0.0f), Float::sum, Float::compare, i -> Float.valueOf(-i.floatValue()));
        private final ISimpleAdapter<T, ? super Tag, ? super JsonElement> adapter;
        private final T identity;
        private final BinaryOperator<T> operator;
        private final Comparator<T> ordering;
        private final UnaryOperator<T> inverse;

        public Group(ISimpleAdapter<T, ? super Tag, ? super JsonElement> adapter, T identity, BinaryOperator<T> operator, Comparator<T> ordering, UnaryOperator<T> inverse) {
            this.adapter = adapter;
            this.identity = identity;
            this.operator = operator;
            this.ordering = ordering;
            this.inverse = inverse;
        }

        public ISimpleAdapter<T, ? super Tag, ? super JsonElement> getAdapter() {
            return this.adapter;
        }

        public T getIdentity() {
            return this.identity;
        }

        public BinaryOperator<T> getOperator() {
            return this.operator;
        }

        public Comparator<T> getOrdering() {
            return this.ordering;
        }

        public UnaryOperator<T> getInverse() {
            return this.inverse;
        }
    }

    public static abstract class Config
    implements ISerializable<CompoundTag, JsonObject> {
        protected final Map<String, Tag> variables = new LinkedHashMap<String, Tag>();

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_3.writeBits(this.variables.size(), buffer);
            this.variables.forEach((name, value) -> {
                Adapters.UTF_8.writeBits((String)name, buffer);
                Adapters.GENERIC_NBT.writeBits(value, buffer);
            });
        }

        @Override
        public void readBits(BitBuffer buffer) {
            this.variables.clear();
            int size = (Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow();
            for (int i = 0; i < size; ++i) {
                this.variables.put(Adapters.UTF_8.readBits(buffer).orElseThrow(), (Tag)Adapters.GENERIC_NBT.readBits(buffer).orElseThrow());
            }
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return Optional.of(new CompoundTag()).map(nbt -> {
                CompoundTag variables = new CompoundTag();
                this.variables.forEach((arg_0, arg_1) -> ((CompoundTag)variables).m_128365_(arg_0, arg_1));
                nbt.m_128365_("variables", (Tag)variables);
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.variables.clear();
            CompoundTag variables = nbt.m_128469_("variables");
            for (String name : variables.m_128431_()) {
                this.variables.put(name, variables.m_128423_(name));
            }
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return Optional.of(new JsonObject()).map(json -> {
                JsonObject variables = new JsonObject();
                this.variables.forEach((name, value) -> Adapters.GENERIC_NBT.writeJson(value).ifPresent(tag -> variables.add(name, tag)));
                json.add("variables", (JsonElement)variables);
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            this.variables.clear();
            JsonElement jsonElement = json.get("variables");
            if (jsonElement instanceof JsonObject) {
                JsonObject variables = (JsonObject)jsonElement;
                for (String name : variables.keySet()) {
                    Adapters.GENERIC_NBT.readJson(variables.get(name)).ifPresent(tag -> this.variables.put(name, (Tag)tag));
                }
            }
        }
    }

    public static class Adapter {
        public static TypeSupplierAdapter<? extends TaskCounter<Integer, ?>> INT = new TypeSupplierAdapter<TaskCounter<Integer, ?>>("type", true){
            {
                this.register("target", TargetTaskCounter.class, TaskCounter::ofTargetInt);
                this.register("sliding_timed_target", SlidingTimedTargetTaskCounter.class, TaskCounter::ofSlidingTargetInt);
            }
        };
        public static TypeSupplierAdapter<? extends TaskCounter<Float, ?>> FLOAT = new TypeSupplierAdapter<TaskCounter<Float, ?>>("type", true){
            {
                this.register("target", TargetTaskCounter.class, TaskCounter::ofTargetFloat);
                this.register("sliding_timed_target", SlidingTimedTargetTaskCounter.class, TaskCounter::ofSlidingTargetFloat);
            }
        };
    }
}

