/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.helper.SkillFrame;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.AchievementTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.TimedTask;
import iskallia.vault.task.renderer.DelegatedTaskRenderer;
import iskallia.vault.task.renderer.PanRegionRenderer;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.Vec2d;
import iskallia.vault.task.renderer.context.AchievementRendererContext;
import iskallia.vault.task.renderer.context.RendererContext;
import iskallia.vault.task.util.IProgressTask;
import iskallia.vault.task.util.TaskProgress;
import iskallia.vault.util.ResourceBoundary;
import iskallia.vault.util.TextUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class AchievementRenderer {

    public static class ModifierListRoot
    extends TaskRenderer<AchievementTask, AchievementRendererContext> {
        private final Root root;

        public ModifierListRoot(Root root) {
            this.root = root;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(AchievementTask task, AchievementRendererContext context) {
            context.push();
            context.translate(0.0, 0.0, 0.0);
            context.drawNineSlice(ScreenTextures.INSET_GREY_BACKGROUND, 0, -1, (int)context.getSize().getX(), (int)context.getSize().getY() + 2);
            if (this.root.selected != null) {
                task.streamChildren().toList().get(this.root.selected).onRender(context);
                context.renderModifiers();
            }
            context.pop();
        }
    }

    public static class DetailsRoot
    extends PanRegionRenderer<AchievementTask, AchievementRendererContext> {
        private final Root root;

        public DetailsRoot(Root root) {
            this.root = root;
        }

        @Override
        protected Vec2d getSize(AchievementTask task, AchievementRendererContext context) {
            return context.getSize();
        }

        @Override
        protected PanRegionRenderer.ScrollType getScrollType(AchievementTask task, AchievementRendererContext context) {
            return PanRegionRenderer.ScrollType.VERTICAL;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected void onRenderForeground(AchievementTask task, AchievementRendererContext context) {
            context.push();
            context.translate(2.0, 2.0, 0.0);
            context.drawNineSlice(ScreenTextures.DEFAULT_WINDOW_BACKGROUND, -20, -20, (int)context.getSize().getX() + 40, (int)context.getSize().getY() + 120);
            if (this.root.selected != null) {
                task.streamChildren().toList().get(this.root.selected).onRender(context);
            }
            context.pop();
        }
    }

    public static class OverviewRoot
    extends PanRegionRenderer<AchievementTask, AchievementRendererContext> {
        private final Root root;

        public OverviewRoot(Root root) {
            this.root = root;
        }

        @Override
        protected Vec2d getSize(AchievementTask task, AchievementRendererContext context) {
            return context.getSize();
        }

        @Override
        protected PanRegionRenderer.ScrollType getScrollType(AchievementTask task, AchievementRendererContext context) {
            return PanRegionRenderer.ScrollType.ZOOM;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(AchievementTask task, AchievementRendererContext context) {
            super.onRender(task, context);
            Vec2d centerButton = this.getCenterButtonPos(task, context);
            NineSlice.TextureRegion buttonTexture = this.isMouseOverCenterButton(task, context) ? ScreenTextures.BUTTON_EMPTY_HOVER : ScreenTextures.BUTTON_EMPTY;
            context.drawNineSlice(buttonTexture, (int)centerButton.getX(), (int)centerButton.getY(), 16, 16);
            int previous = context.setShaderTexture(ScreenTextures.UI_RESOURCE);
            context.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            context.blit((int)centerButton.getX(), (int)centerButton.getY() - 1, 192, 0, 16, 16, 256, 256);
            context.setShaderTexture(previous);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected void onRenderForeground(AchievementTask task, AchievementRendererContext context) {
            List<Task> children = task.streamChildren().toList();
            for (int i = 0; i < children.size(); ++i) {
                Task child = children.get(i);
                context.setSelected(Objects.equals(i, this.root.selected));
                child.onRender(context);
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean onMouseClicked(AchievementTask task, int button, AchievementRendererContext context) {
            if (this.isMouseOverCenterButton(task, context)) {
                this.resetTranslation();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)1.0f, (float)0.75f));
                return true;
            }
            if (!this.isInBounds(context.getMouse(), task, context)) {
                return false;
            }
            this.clickedPos = context.getMouse();
            context.pushMouse(context.getMouse().subtract(this.getTranslation(task, context)));
            this.dragging = true;
            int index = -1;
            List<Task> children = task.streamChildren().toList();
            for (int i = 0; i < children.size(); ++i) {
                if (!children.get(i).onMouseClicked(button, context)) continue;
                this.dragging = false;
                index = i;
                break;
            }
            if (index >= 0) {
                this.root.selected = index;
            }
            context.popMouse();
            return true;
        }

        @Override
        protected Vec2d getCenterButtonPos(AchievementTask task, AchievementRendererContext context) {
            return new Vec2d((int)this.getSize(task, context).getX() - 18, (int)this.getSize(task, context).getY() - 18);
        }

        protected boolean isMouseOverCenterButton(AchievementTask task, AchievementRendererContext context) {
            Vec2d centerButton = this.getCenterButtonPos(task, context);
            return context.getMouse().getX() >= centerButton.getX() && context.getMouse().getX() <= centerButton.getX() + 16.0 && context.getMouse().getY() >= centerButton.getY() && context.getMouse().getY() <= centerButton.getY() + 16.0;
        }
    }

    public static class Root
    extends DelegatedTaskRenderer<AchievementTask, AchievementRendererContext> {
        private final OverviewRoot overview = new OverviewRoot(this);
        private final DetailsRoot details = new DetailsRoot(this);
        private final ModifierListRoot modifiers = new ModifierListRoot(this);
        private Integer selected;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public TaskRenderer<AchievementTask, AchievementRendererContext> getDelegate(AchievementTask task, AchievementRendererContext context) {
            return switch (context.getMedium()) {
                default -> throw new IncompatibleClassChangeError();
                case AchievementRendererContext.Medium.OVERVIEW -> this.overview;
                case AchievementRendererContext.Medium.DETAILS -> this.details;
                case AchievementRendererContext.Medium.MODIFIERS -> this.modifiers;
                case AchievementRendererContext.Medium.STATS -> null;
            };
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            this.overview.writeBits(buffer);
            this.details.writeBits(buffer);
            this.modifiers.writeBits(buffer);
            Adapters.INT.asNullable().writeBits(this.selected, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.overview.readBits(buffer);
            this.details.readBits(buffer);
            this.modifiers.readBits(buffer);
            this.selected = Adapters.INT.asNullable().readBits(buffer).orElse(null);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                this.overview.writeNbt().ifPresent(tag -> nbt.m_128365_("overview", (Tag)tag));
                this.details.writeNbt().ifPresent(tag -> nbt.m_128365_("details", (Tag)tag));
                this.modifiers.writeNbt().ifPresent(tag -> nbt.m_128365_("modifiers", (Tag)tag));
                Adapters.INT.asNullable().writeNbt(this.selected).ifPresent(tag -> nbt.m_128365_("selected", tag));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.overview.readNbt(nbt.m_128469_("overview"));
            this.details.readNbt(nbt.m_128469_("details"));
            this.modifiers.readNbt(nbt.m_128469_("modifiers"));
            this.selected = Adapters.INT.asNullable().readNbt(nbt.m_128423_("selected")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                this.overview.writeJson().ifPresent(tag -> json.add("overview", (JsonElement)tag));
                this.details.writeJson().ifPresent(tag -> json.add("details", (JsonElement)tag));
                this.modifiers.writeJson().ifPresent(tag -> json.add("modifiers", (JsonElement)tag));
                Adapters.INT.asNullable().writeJson(this.selected).ifPresent(value -> json.add("selected", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.overview.readJson(json.getAsJsonObject("overview"));
            this.details.readJson(json.getAsJsonObject("details"));
            this.modifiers.readJson(json.getAsJsonObject("modifiers"));
            this.selected = Adapters.INT.asNullable().readJson((JsonElement)json.getAsJsonObject("selected")).orElse(null);
        }
    }

    public static class Base<T extends Task, C extends AchievementRendererContext>
    extends TaskRenderer<T, C> {
        protected String name;
        protected String description;
        protected ResourceLocation icon;
        protected Vec2d position;
        protected boolean hidden;

        public Base() {
        }

        public Base(String name, String description, ResourceLocation icon, Vec2d position, boolean hidden) {
            this.name = name;
            this.description = description;
            this.icon = icon;
            this.position = position;
            this.hidden = hidden;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(T task, C context) {
            if (((AchievementRendererContext)context).isOverview()) {
                if (!this.hidden) {
                    this.onRenderOverview(task, context);
                }
            } else if (((AchievementRendererContext)context).isDetailsPane()) {
                this.onRenderDetails(task, context);
            }
            for (Task child : ((Task)task).getChildren()) {
                child.onRender((RendererContext)context);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onRenderOverview(T task, C context) {
            if (this.icon == null) {
                return;
            }
            boolean completed = ((Task)task).isCompleted();
            boolean mouseOver = this.isMouseOver(task, context);
            ResourceBoundary icon = SkillFrame.STAR.getResourceBoundary();
            int vOffset = 0;
            if (((AchievementRendererContext)context).isSelected() || mouseOver) {
                vOffset = -31;
            } else if (completed) {
                vOffset = 31;
            }
            int previous = ((RendererContext)context).setShaderTexture(icon.getResource());
            ((RendererContext)context).blit((int)Math.round(this.position.getX()), (int)Math.round(this.position.getY()), icon.getU(), icon.getV() + vOffset, icon.getWidth(), icon.getHeight(), 256, 256);
            ((RendererContext)context).setShaderTexture(previous);
            if (this.icon != null && !this.icon.equals((Object)VaultMod.id("empty"))) {
                ((AchievementRendererContext)context).renderIcon(this.icon, this.position.add(7.0, 7.0));
            }
            if (mouseOver) {
                ((RendererContext)context).renderTooltip(List.of(new TextComponent(this.name)));
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onRenderDetails(T task, C context) {
            int lineHeight = 12;
            int width = (int)((AchievementRendererContext)context).getSize().getX() - 4;
            if (!StringUtils.isBlank((CharSequence)this.name)) {
                ((RendererContext)context).translate(0.0, 4.0, 0.0);
                MutableComponent name = new TextComponent(this.name).m_130940_(ChatFormatting.BLACK);
                ((RendererContext)context).renderText((Component)name, 0.0f, 0.0f, false, false);
                ((RendererContext)context).translate(0.0, lineHeight + 4, 0.0);
            }
            if (!StringUtils.isBlank((CharSequence)this.description)) {
                MutableComponent description = new TextComponent(this.description).m_130940_(ChatFormatting.DARK_GRAY);
                ((RendererContext)context).renderText((Component)description, 0.0f, 0.0f, width, false, false, -1, false);
                int descriptionHeight = TextUtil.getLineHeight((FormattedText)description, width) * lineHeight;
                ((RendererContext)context).translate(0.0, descriptionHeight, 0.0);
            }
            if (task instanceof IProgressTask) {
                IProgressTask progressTask = (IProgressTask)task;
                TaskProgress taskProgress = progressTask.getProgress();
                Number current = taskProgress.getCurrent();
                Number max = taskProgress.getTarget();
                double progress = current.doubleValue() / max.doubleValue();
                ((AchievementRendererContext)context).renderProgressBar(String.format("%s/%s", current, max), progress, 0, 0, width + 1, 10, false);
                ((RendererContext)context).translate(0.0, lineHeight, 0.0);
            }
            if (((AchievementRendererContext)context).getTimedTask() != null) {
                TimedTask timedTask = ((AchievementRendererContext)context).getTimedTask();
                long elapsed = timedTask.getElapsed();
                long duration = timedTask.getDuration();
                double progress = (double)elapsed / (double)duration;
                long durationMillis = (duration / 20L - elapsed / 20L) * 1000L;
                String timeRemaining = DurationFormatUtils.formatDuration((long)durationMillis, (String)"mm:ss");
                ((AchievementRendererContext)context).renderProgressBar(timeRemaining, progress, 0, 0, width + 1, 10, true);
                ((RendererContext)context).translate(0.0, lineHeight, 0.0);
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean onMouseClicked(T task, int button, C context) {
            if (this.isMouseOver(task, context)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12490_, (float)1.0f, (float)0.75f));
                return true;
            }
            return super.onMouseClicked(task, button, context);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean isMouseOver(T task, C context) {
            if (((AchievementRendererContext)context).isOverview()) {
                if (this.position == null) {
                    return super.isMouseOver(task, context);
                }
                Vec2d mouse = ((RendererContext)context).getMouse();
                return mouse.getX() >= this.position.getX() && mouse.getX() < this.position.getX() + 30.0 && mouse.getY() >= this.position.getY() && mouse.getY() < this.position.getY() + 30.0;
            }
            return false;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.UTF_8.asNullable().writeBits(this.name, buffer);
            Adapters.UTF_8.asNullable().writeBits(this.description, buffer);
            Adapters.IDENTIFIER.asNullable().writeBits(this.icon, buffer);
            Adapters.VEC_2D.writeBits(this.position, buffer);
            Adapters.BOOLEAN.writeBits(this.hidden, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.name = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            this.description = Adapters.UTF_8.asNullable().readBits(buffer).orElse(null);
            this.icon = Adapters.IDENTIFIER.asNullable().readBits(buffer).orElse(null);
            this.position = Adapters.VEC_2D.readBits(buffer).orElseThrow();
            this.hidden = Adapters.BOOLEAN.readBits(buffer).orElse(false);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.UTF_8.writeNbt(this.name).ifPresent(value -> nbt.m_128365_("name", value));
                Adapters.UTF_8.writeNbt(this.description).ifPresent(value -> nbt.m_128365_("description", value));
                Adapters.IDENTIFIER.writeNbt(this.icon).ifPresent(value -> nbt.m_128365_("icon", value));
                Adapters.VEC_2D.writeNbt(this.position).ifPresent(value -> nbt.m_128365_("position", value));
                Adapters.BOOLEAN.writeNbt(this.hidden).ifPresent(value -> nbt.m_128365_("hidden", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.name = Adapters.UTF_8.readNbt(nbt.m_128423_("name")).orElse(null);
            this.description = Adapters.UTF_8.readNbt(nbt.m_128423_("description")).orElse(null);
            this.icon = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("icon")).orElse(null);
            this.position = Adapters.VEC_2D.readNbt(nbt.m_128423_("position")).orElse(new Vec2d());
            this.hidden = Adapters.BOOLEAN.readNbt(nbt.m_128423_("hidden")).orElse(false);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.UTF_8.writeJson(this.name).ifPresent(value -> json.add("name", value));
                Adapters.UTF_8.writeJson(this.description).ifPresent(value -> json.add("description", value));
                Adapters.IDENTIFIER.writeJson(this.icon).ifPresent(value -> json.add("icon", value));
                Adapters.VEC_2D.writeJson(this.position).ifPresent(value -> json.add("position", value));
                Adapters.BOOLEAN.writeJson(this.hidden).ifPresent(value -> json.add("hidden", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.name = Adapters.UTF_8.readJson(json.get("name")).orElse(null);
            this.description = Adapters.UTF_8.readJson(json.get("description")).orElse(null);
            this.icon = Adapters.IDENTIFIER.readJson(json.get("icon")).orElse(null);
            this.position = Adapters.VEC_2D.readJson(json.get("position")).orElse(new Vec2d());
            this.hidden = Adapters.BOOLEAN.readJson(json.get("hidden")).orElse(false);
        }
    }
}

