/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import iskallia.vault.VaultMod;
import iskallia.vault.client.render.IVaultOptions;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModKeybinds;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.BingoScrollMessage;
import iskallia.vault.task.BingoTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.counter.SlidingTimedTargetTaskCounter;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.context.TaskRendererContext;
import iskallia.vault.task.util.IProgressTask;
import iskallia.vault.task.util.TaskProgress;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BingoRenderer {

    public static class Leaf
    extends TaskRenderer<Task, TaskRendererContext> {
        public String name;
        public ResourceLocation icon;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(Task task, TaskRendererContext context) {
            SlidingTimedTargetTaskCounter counter;
            TextComponent current;
            IProgressTask progressTask;
            List<Task> children = task.streamChildren().toList();
            if (task.isCompleted() && !children.isEmpty()) {
                for (Task child : children) {
                    child.onRender(context);
                }
                return;
            }
            context.push();
            if (context.isExpandedView()) {
                context.scale(0.9f, 0.9f, 0.9f);
                this.addInProgressBackground(task, context);
            } else {
                context.scale(0.8f, 0.8f, 0.8f);
            }
            context.translate(-8.0, -8.0, 0.0);
            context.blit(this.icon, 0, 0, 0, 0, 16, 16, 16, 16);
            float textScale = 0.64f;
            context.scale(textScale, textScale, textScale);
            if (task instanceof IProgressTask) {
                progressTask = (IProgressTask)((Object)task);
                TaskProgress progress = progressTask.getProgress();
                current = new TextComponent(String.valueOf(progress.getCurrent().intValue()));
                if (!task.isCompleted() && progress.getProgress() > 0.0) {
                    current.m_130948_(Style.f_131099_.m_178520_(65280).m_131136_(Boolean.valueOf(true)));
                }
                MutableComponent text = new TextComponent("").m_7220_((Component)current).m_130946_("/" + progress.getTarget().intValue());
                context.renderText((Component)text, 8.5f / textScale, 18.0f / textScale, true, true, context.isCompleted() && !context.isExpandedView() ? 65280 : 0xFFFFFF, false);
            }
            if (task instanceof ProgressConfiguredTask && (current = ((ProgressConfiguredTask)(progressTask = (ProgressConfiguredTask)task)).getCounter()) instanceof SlidingTimedTargetTaskCounter && (counter = (SlidingTimedTargetTaskCounter)current).getWindow() >= 20) {
                TextComponent text = new TextComponent(counter.getWindow() / 20 + "s");
                context.renderText((Component)text, 1.5f / textScale, 2.0f / textScale, true, true, 0xFFFFFF, false);
            }
            if (context.isCompleted()) {
                context.blit(VaultMod.id("textures/gui/bingo/checkmark.png"), (int)(10.0f / textScale), -((int)(3.0f / textScale)), 0, 0, 16, 16, 16, 16);
            }
            float descScale = 0.75f;
            context.scale(descScale, descScale, descScale);
            TextComponent description = new TextComponent(this.name);
            context.renderText((Component)description, 8.5f / textScale / descScale, 25.5f / textScale / descScale, context.isExpandedView() ? 75 : 60, true, true, context.isCompleted() && !context.isExpandedView() ? 3912003 : -3355444, false);
            context.pop();
        }

        private void addInProgressBackground(Task task, TaskRendererContext context) {
            if (task.isCompleted() || !(task instanceof IProgressTask)) {
                return;
            }
            IProgressTask progressTask = (IProgressTask)((Object)task);
            double percentage = progressTask.getProgress().getProgress();
            if (percentage == 0.0) {
                return;
            }
            int color = this.getColor(percentage);
            float cellSize = 42.0f;
            int padding = (int)(12.0 - percentage * 10.0);
            context.drawColoredRect(-cellSize / 2.0f + (float)padding, -9.0f, cellSize - (float)(padding * 2) + 1.0f, cellSize - 19.0f, color | 0x44000000);
        }

        private int getColor(double percentage) {
            int noProgressColor = 0xCCFFCC;
            int doneColor = 65280;
            int red = (noProgressColor >> 16 & 0xFF) + (int)((double)((doneColor >> 16 & 0xFF) - (noProgressColor >> 16 & 0xFF)) * percentage);
            int green = (noProgressColor >> 8 & 0xFF) + (int)((double)((doneColor >> 8 & 0xFF) - (noProgressColor >> 8 & 0xFF)) * percentage);
            int blue = (noProgressColor & 0xFF) + (int)((double)((doneColor & 0xFF) - (noProgressColor & 0xFF)) * percentage);
            int color = red << 16 | green << 8 | blue;
            return color;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.UTF_8.writeBits(this.name, buffer);
            Adapters.IDENTIFIER.writeBits(this.icon, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.name = Adapters.UTF_8.readBits(buffer).orElse(null);
            this.icon = Adapters.IDENTIFIER.readBits(buffer).orElse(null);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.UTF_8.writeNbt(this.name).ifPresent(value -> nbt.m_128365_("name", value));
                Adapters.IDENTIFIER.writeNbt(this.icon).ifPresent(value -> nbt.m_128365_("icon", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.name = Adapters.UTF_8.readNbt(nbt.m_128423_("name")).orElse(null);
            this.icon = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("icon")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.UTF_8.writeJson(this.name).ifPresent(value -> json.add("name", value));
                Adapters.IDENTIFIER.writeJson(this.icon).ifPresent(value -> json.add("icon", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.name = Adapters.UTF_8.readJson(json.get("name")).orElse(null);
            this.icon = Adapters.IDENTIFIER.readJson(json.get("icon")).orElse(null);
        }
    }

    public static class Root
    extends TaskRenderer<BingoTask, TaskRendererContext> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(BingoTask root, TaskRendererContext context) {
            Minecraft minecraft = Minecraft.m_91087_();
            context.setUuid(minecraft.f_91074_ == null ? null : minecraft.f_91074_.m_142081_());
            context.setExpandedView(minecraft.f_91080_ == null && ModKeybinds.openBingo.m_90857_());
            if (context.isExpandedView()) {
                this.renderExpanded(root, context);
            } else {
                this.renderCompact(root, context);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderExpanded(BingoTask root, TaskRendererContext context) {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            float cellSize = 42.0f;
            float gridWidth = cellSize * (float)root.getWidth();
            float gridHeight = cellSize * (float)root.getHeight();
            float maxGridWidth = 294.0f;
            float maxGridHeight = 210.0f;
            float scale = Math.min(maxGridWidth / gridWidth, maxGridHeight / gridHeight);
            float userScale = ((IVaultOptions)minecraft.f_91066_).getObjectiveScale();
            float totalScale = scale * userScale;
            context.push();
            context.translate((float)window.m_85445_() / 2.0f - gridWidth * totalScale / 2.0f, 5.0, 0.0);
            context.scale(totalScale, totalScale, totalScale);
            context.drawColoredRect(-1.0f, -1.0f, gridWidth + 3.0f, gridHeight + 3.0f, Integer.MIN_VALUE);
            context.translate(cellSize / 2.0f, 13.0, 0.0);
            for (int column = 0; column < root.getWidth(); ++column) {
                context.push();
                for (int row = 0; row < root.getHeight(); ++row) {
                    boolean selected = false;
                    for (int index : root.getSelectedLine(context.getUuid())) {
                        if (root.getIndex(row, column) != index) continue;
                        selected = true;
                        break;
                    }
                    if (selected) {
                        context.drawColoredRect(-cellSize / 2.0f + 1.0f, -12.0f, cellSize - 1.0f, cellSize - 1.0f, 1694498560);
                    }
                    if (root.getState(row, column) != BingoTask.State.INCOMPLETE) {
                        context.drawColoredRect(-cellSize / 2.0f + 1.0f, -12.0f, cellSize - 1.0f, cellSize - 1.0f, 1677786880);
                    }
                    context.setCompleted(root.isCompleted(row, column));
                    root.getChild(row, column).onRender(context);
                    context.translate(0.0, cellSize, 0.0);
                }
                context.pop();
                context.translate(cellSize, 0.0, 0.0);
            }
            context.pop();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void renderCompact(BingoTask root, TaskRendererContext context) {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            HashMap<Integer, Task> children = new HashMap<Integer, Task>();
            for (int index2 : root.getSelectedLine(context.getUuid())) {
                children.put(index2, root.getChild(index2));
            }
            int sizeX = 30 * children.size();
            int spanX = 30 * (children.size() - 1);
            float userScale = ((IVaultOptions)minecraft.f_91066_).getObjectiveScale();
            context.push();
            context.translate((float)window.m_85445_() / 2.0f - (float)spanX * userScale / 2.0f, 16.0, 0.0);
            context.scale(userScale, userScale, userScale);
            children.forEach((index, child) -> {
                context.push();
                context.scale(1.2f, 1.2f, 1.2f);
                context.setCompleted(root.isCompleted((int)index));
                child.onRender(context);
                context.pop();
                context.translate(30.0, 0.0, 0.0);
            });
            context.pop();
            context.push();
            float gridHeight = 45.0f;
            float gridWidth = gridHeight / (float)root.getHeight() * (float)root.getWidth();
            float cellWidth = gridWidth / (float)root.getWidth();
            float cellHeight = gridHeight / (float)root.getHeight();
            context.translate((float)window.m_85445_() / 2.0f - (float)sizeX * userScale / 2.0f - 7.0f - gridWidth * userScale, 2.0, 0.0);
            context.scale(userScale, userScale, userScale);
            context.drawColoredRect(-0.25f, -0.25f, gridWidth + 1.0f, gridHeight + 1.0f, 0x64000000);
            for (int column = 0; column < root.getWidth(); ++column) {
                context.push();
                for (int row = 0; row < root.getHeight(); ++row) {
                    context.drawColoredRect(1.0f, 1.0f, cellWidth - 1.5f, cellHeight - 1.5f, root.getState(row, column) == BingoTask.State.INCOMPLETE ? 0x15FFFFFF : 1677786880);
                    for (int index3 : root.getSelectedLine(context.getUuid())) {
                        if (root.getIndex(row, column) != index3) continue;
                        context.drawColoredRect(0.25f, 0.25f, cellWidth, cellHeight, 0x40FFFF00);
                        break;
                    }
                    context.translate(0.0, cellHeight, 0.0);
                }
                context.pop();
                context.translate(cellWidth, 0.0, 0.0);
            }
            context.pop();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean onMouseScrolled(BingoTask task, double delta, TaskRendererContext context) {
            Minecraft minecraft = Minecraft.m_91087_();
            int keyValue = ModKeybinds.openBingo.getKey().m_84873_();
            boolean inGame = minecraft.f_91080_ == null;
            context.setExpandedView(inGame && keyValue > 0 && InputConstants.m_84830_((long)minecraft.m_91268_().m_85439_(), (int)keyValue));
            if (inGame) {
                UUID uuid;
                UUID uUID = uuid = minecraft.f_91074_ != null ? minecraft.f_91074_.m_142081_() : null;
                if (uuid != null) {
                    task.progressBingoLine(uuid, delta < 0.0 ? 1 : -1);
                }
                ModNetwork.CHANNEL.sendToServer((Object)new BingoScrollMessage(delta));
                return true;
            }
            return super.onMouseScrolled(task, delta, context);
        }
    }
}

