/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import com.google.gson.JsonObject;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.CraftingTask;
import iskallia.vault.task.renderer.AchievementRenderer;
import iskallia.vault.task.renderer.context.AchievementRendererContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CraftingTaskRenderer {

    public static class Achievement
    extends AchievementRenderer.Base<CraftingTask, AchievementRendererContext> {
        protected List<Recipe<?>> cache = null;

        public List<Recipe<?>> getRecipes(CraftingTask task) {
            if (this.cache == null) {
                this.cache = new ArrayList();
                Collection recipeList = this.getRecipeManager().m_44051_();
                for (Recipe recipe : recipeList) {
                    if (!((CraftingTask.Config)task.getConfig()).filter.test(recipe.m_8043_())) continue;
                    this.cache.add(recipe);
                }
            }
            return this.cache;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRenderDetails(CraftingTask task, AchievementRendererContext context) {
            super.onRenderDetails(task, context);
            int height = 64;
            int backgroundWidth = (int)context.getSize().getX() - 3;
            context.drawNineSlice(ScreenTextures.DEFAULT_WINDOW_BACKGROUND, 0, 0, backgroundWidth, height);
            List<Recipe<?>> recipes = this.getRecipes(task);
            if (!recipes.isEmpty()) {
                context.push();
                context.translate((double)backgroundWidth / 2.0 - 45.0, 5.0, 0.0);
                Recipe<?> recipe = recipes.get(0);
                RecipeType type = recipe.m_6671_();
                if (type == RecipeType.f_44107_) {
                    ItemStack resultItem;
                    this.renderSlots(context);
                    if (recipe instanceof ShapedRecipe) {
                        ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                        this.renderShaped(context, shapedRecipe);
                    }
                    if (recipe instanceof ShapelessRecipe) {
                        ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
                        this.renderShapeless(context, shapeless);
                    }
                    if ((resultItem = recipe.m_8043_()).m_41619_()) {
                        return;
                    }
                    this.renderResult(context, resultItem);
                }
                context.pop();
            }
            context.translate(0.0, height + 2, 0.0);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void renderResult(AchievementRendererContext context, ItemStack resultItem) {
            int x = 72;
            int y = 18;
            context.push();
            context.translate(x, y, 0.0);
            context.renderStack(resultItem, 0, 0, 1.0f, true, true);
            context.pop();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void renderShapeless(AchievementRendererContext context, ShapelessRecipe shapeless) {
            NonNullList ingredients = shapeless.m_7527_();
            boolean large = ingredients.size() > 4;
            int index = 0;
            context.push();
            for (int column = 0; column < (large ? 3 : 2); ++column) {
                context.push();
                for (int row = 0; row < (large ? 3 : 2); ++row) {
                    if (ingredients.size() <= index) continue;
                    if (!ingredients.isEmpty() && ((Ingredient)ingredients.get(index)).m_43908_().length > 0) {
                        ItemStack stack = ((Ingredient)ingredients.get(index)).m_43908_()[0];
                        context.renderStack(stack, 0, 0, 1.0f, true, true);
                        context.translate(18.0, 0.0, 0.0);
                    }
                    ++index;
                }
                context.pop();
                context.translate(0.0, 18.0, 0.0);
            }
            context.pop();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void renderSlots(AchievementRendererContext context) {
            context.push();
            for (int row = 0; row < 3; ++row) {
                context.push();
                for (int column = 0; column < 3; ++column) {
                    context.renderStack(ItemStack.f_41583_, 0, 0, 1.0f, true, false);
                    context.translate(0.0, 18.0, 0.0);
                }
                context.pop();
                context.translate(18.0, 0.0, 0.0);
            }
            context.pop();
        }

        @OnlyIn(value=Dist.CLIENT)
        private void renderShaped(AchievementRendererContext context, ShapedRecipe shapedRecipe) {
            int width = shapedRecipe.m_44220_();
            int height = shapedRecipe.m_44221_();
            NonNullList ingredients = shapedRecipe.m_7527_();
            int index = 0;
            context.push();
            for (int row = 0; row < height; ++row) {
                context.push();
                for (int column = 0; column < width; ++column) {
                    if (!ingredients.isEmpty()) {
                        if (!((Ingredient)ingredients.get(index)).m_43947_()) {
                            ItemStack stack = ((Ingredient)ingredients.get(index)).m_43908_()[0];
                            context.renderStack(stack, 0, 0, 1.0f, true, true);
                        }
                        context.translate(18.0, 0.0, 0.0);
                    }
                    ++index;
                }
                context.pop();
                context.translate(0.0, 18.0, 0.0);
            }
            context.pop();
        }

        protected RecipeManager getRecipeManager() {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                throw new IllegalStateException("Level is null when attempting to instantiate RecipeRenderer");
            }
            return level.m_7465_();
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt();
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson();
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
        }
    }
}

