/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import com.google.gson.JsonObject;
import iskallia.vault.VaultMod;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.GreedTask;
import iskallia.vault.task.ProgressConfiguredTask;
import iskallia.vault.task.Task;
import iskallia.vault.task.counter.SlidingTimedTargetTaskCounter;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.context.GreedTaskRendererContext;
import iskallia.vault.task.util.IProgressTask;
import iskallia.vault.task.util.TaskProgress;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GreedRenderer {

    public static class Leaf
    extends TaskRenderer<Task, GreedTaskRendererContext> {
        public String name;
        public ResourceLocation icon;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(Task task, GreedTaskRendererContext context) {
            SlidingTimedTargetTaskCounter counter;
            TextComponent current;
            IProgressTask progressTask;
            List<Task> children = task.streamChildren().toList();
            if (task.isCompleted() && !children.isEmpty()) {
                for (Task child : children) {
                    child.onRender(context);
                }
                return;
            }
            context.push();
            context.scale(0.8f, 0.8f, 0.8f);
            context.translate(-8.0, -8.0, 0.0);
            context.blit(this.icon, 0, 0, 0, 0, 16, 16, 16, 16);
            float textScale = 0.64f;
            context.scale(textScale, textScale, textScale);
            if (task instanceof IProgressTask) {
                progressTask = (IProgressTask)((Object)task);
                TaskProgress progress = progressTask.getProgress();
                current = new TextComponent(String.valueOf(progress.getCurrent().intValue()));
                if (!task.isCompleted() && progress.getProgress() > 0.0) {
                    current.m_130948_(Style.f_131099_.m_178520_(65280).m_131136_(Boolean.valueOf(true)));
                }
                MutableComponent text = new TextComponent("").m_7220_((Component)current).m_130946_("/" + progress.getTarget().intValue());
                context.renderText((Component)text, 8.5f / textScale, 18.0f / textScale, true, true, context.isCompleted() ? 65280 : 0xFFFFFF, false);
            }
            if (task instanceof ProgressConfiguredTask && (current = ((ProgressConfiguredTask)(progressTask = (ProgressConfiguredTask)task)).getCounter()) instanceof SlidingTimedTargetTaskCounter && (counter = (SlidingTimedTargetTaskCounter)current).getWindow() >= 20) {
                TextComponent text = new TextComponent(counter.getWindow() / 20 + "s");
                context.renderText((Component)text, 1.5f / textScale, 2.0f / textScale, true, true, 0xFFFFFF, false);
            }
            if (context.isCompleted()) {
                context.blit(VaultMod.id("textures/gui/bingo/checkmark.png"), (int)(10.0f / textScale), -((int)(3.0f / textScale)), 0, 0, 16, 16, 16, 16);
            }
            if (context.getReward() != null && !context.getReward().m_41619_() && context.getReward().m_41613_() > 0) {
                context.renderStack(context.getReward(), 0, 0, 1.0f, false, false);
            }
            float descScale = 0.75f;
            context.scale(descScale, descScale, descScale);
            TextComponent description = new TextComponent(this.name);
            context.renderText((Component)description, 8.5f / textScale / descScale, 25.5f / textScale / descScale, 60, true, true, context.isCompleted() ? 3912003 : -3355444, false);
            context.pop();
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            super.writeBits(buffer);
            Adapters.UTF_8.writeBits(this.name, buffer);
            Adapters.IDENTIFIER.writeBits(this.icon, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            super.readBits(buffer);
            this.name = Adapters.UTF_8.readBits(buffer).orElse(null);
            this.icon = Adapters.IDENTIFIER.readBits(buffer).orElse(null);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            return super.writeNbt().map(nbt -> {
                Adapters.UTF_8.writeNbt(this.name).ifPresent(value -> nbt.m_128365_("name", value));
                Adapters.IDENTIFIER.writeNbt(this.icon).ifPresent(value -> nbt.m_128365_("icon", value));
                return nbt;
            });
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            super.readNbt(nbt);
            this.name = Adapters.UTF_8.readNbt(nbt.m_128423_("name")).orElse(null);
            this.icon = Adapters.IDENTIFIER.readNbt(nbt.m_128423_("icon")).orElse(null);
        }

        @Override
        public Optional<JsonObject> writeJson() {
            return super.writeJson().map(json -> {
                Adapters.UTF_8.writeJson(this.name).ifPresent(value -> json.add("name", value));
                Adapters.IDENTIFIER.writeJson(this.icon).ifPresent(value -> json.add("icon", value));
                return json;
            });
        }

        @Override
        public void readJson(JsonObject json) {
            super.readJson(json);
            this.name = Adapters.UTF_8.readJson(json.get("name")).orElse(null);
            this.icon = Adapters.IDENTIFIER.readJson(json.get("icon")).orElse(null);
        }
    }

    public static class Root
    extends TaskRenderer<GreedTask, GreedTaskRendererContext> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(GreedTask task, GreedTaskRendererContext context) {
            Minecraft mc = Minecraft.m_91087_();
            float cellSize = 30.0f;
            float width = cellSize * (float)task.getLength();
            context.push();
            context.translate((float)(mc.m_91268_().m_85445_() / 2) - width / 2.0f, 16.0, 0.0);
            for (int i = 0; i < task.getLength(); ++i) {
                context.push();
                context.setCompleted(task.isTaskCompleted(i));
                Task iTask = task.getTask(i);
                Optional<ItemStack> reward = task.getReward(i);
                reward.ifPresent(context::setReward);
                iTask.onRender(context);
                context.pop();
                context.translate(cellSize, 0.0, 0.0);
            }
            context.pop();
        }
    }
}

