/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import iskallia.vault.task.ItemRewardTask;
import iskallia.vault.task.renderer.TaskRenderer;
import iskallia.vault.task.renderer.Vec2d;
import iskallia.vault.task.renderer.context.AchievementRendererContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRewardRenderer {

    public static class Achievement
    extends TaskRenderer<ItemRewardTask, AchievementRendererContext> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRender(ItemRewardTask task, AchievementRendererContext context) {
            if (context.isDetailsPane()) {
                MutableComponent label = new TextComponent("Items").m_130940_(ChatFormatting.BLACK).m_130940_(ChatFormatting.UNDERLINE);
                context.renderText((Component)label, (int)(context.getSize().getX() / 2.0), 0.0f, true, false);
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                context.translate(0.0, 9 + 2, 0.0);
                List<ItemStack> stacks = ((ItemRewardTask.Config)task.getConfig()).stacks;
                int width = stacks.size() * 18;
                context.translate(context.getSize().getX() / 2.0 - (double)width / 2.0, 0.0, 0.0);
                context.push();
                for (ItemStack stack : stacks) {
                    context.renderStack(stack, 0, 0, 1.0f, true, false);
                    if (this.isMouseOver(task, context)) {
                        context.renderTooltip(stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL));
                    }
                    context.translate(18.0, 0.0, 0.0);
                }
                context.pop();
                context.translate(0.0, 20.0, 0.0);
            }
            super.onRender(task, context);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public boolean isMouseOver(ItemRewardTask task, AchievementRendererContext context) {
            if (context.isDetailsPane()) {
                Vec2d mouse = context.getMouse();
                return mouse.getX() >= 0.0 && mouse.getX() < 18.0 && mouse.getY() >= 0.0 && mouse.getY() < 18.0;
            }
            return super.isMouseOver(task, context);
        }
    }
}

