/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import iskallia.vault.block.VaultOreBlock;
import iskallia.vault.task.MineBlockTask;
import iskallia.vault.task.renderer.AchievementRenderer;
import iskallia.vault.task.renderer.context.AchievementRendererContext;
import iskallia.vault.util.GroupUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MineBlockTaskRenderer {

    public static class Achievement
    extends AchievementRenderer.Base<MineBlockTask, AchievementRendererContext> {
        private List<ItemStack> cache = null;

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onRenderDetails(MineBlockTask task, AchievementRendererContext context) {
            super.onRenderDetails(task, context);
            float scale = 4.0f;
            double center = context.getSize().getX() / 2.0 - 2.0;
            float iconWidth = 18.0f * scale;
            List<ItemStack> items = this.getItems(task);
            int index = (int)(context.getTick() / 30L % (long)items.size());
            context.renderStack(items.get(index), (int)(center - (double)(iconWidth / 2.0f)), 0, scale, true, true);
            context.translate(0.0, 18.0f * scale + 2.0f, 0.0);
        }

        private List<ItemStack> getItems(MineBlockTask task) {
            if (this.cache == null) {
                this.cache = new ArrayList<ItemStack>();
                Set<ResourceLocation> blockIds = GroupUtils.getBlockIdsFor(((MineBlockTask.Config)task.getConfig()).filter);
                for (ResourceLocation blockId : blockIds) {
                    Block block;
                    if (!ForgeRegistries.BLOCKS.containsKey(blockId) || (block = (Block)ForgeRegistries.BLOCKS.getValue(blockId)) == null) continue;
                    ItemStack stack = new ItemStack((ItemLike)block);
                    if (block instanceof VaultOreBlock) {
                        CompoundTag tag = stack.m_41784_();
                        tag.m_128359_("type", "vault_stone");
                        stack.m_41751_(tag);
                    }
                    this.cache.add(stack);
                }
            }
            return this.cache;
        }
    }
}

