/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.client.gui.framework.ScreenTextures;
import iskallia.vault.client.gui.framework.render.NineSlice;
import iskallia.vault.client.gui.helper.UIHelper;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.task.Task;
import iskallia.vault.task.renderer.TranslatableRenderer;
import iskallia.vault.task.renderer.Vec2d;
import iskallia.vault.task.renderer.context.RendererContext;
import java.util.Optional;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.nbt.CompoundTag;

public abstract class PanRegionRenderer<T extends Task, C extends RendererContext>
extends TranslatableRenderer<T, C> {
    private static final double SCROLL_SENSITIVITY = 12.0;
    protected boolean dragging;
    protected Vec2d clickedPos;

    protected abstract Vec2d getSize(T var1, C var2);

    protected abstract ScrollType getScrollType(T var1, C var2);

    protected Vec2d getCenterButtonPos(T task, C context) {
        int centerButtonX = (int)(this.getSize(task, context).getX() - 18.0);
        int centerButtonY = (int)(this.getSize(task, context).getY() - 18.0);
        return new Vec2d(centerButtonX, centerButtonY);
    }

    protected NineSlice.TextureRegion getBackground() {
        return ScreenTextures.INSET_GREY_BACKGROUND;
    }

    protected void onRenderBackground(T task, C context) {
        Vec2d size = this.getSize(task, context);
        GuiComponent.m_93172_((PoseStack)((RendererContext)context).getMatrices(), (int)0, (int)0, (int)((int)size.getX()), (int)((int)size.getY()), (int)0x1FFFFFF);
    }

    protected abstract void onRenderForeground(T var1, C var2);

    @Override
    public void onRender(T task, C context) {
        Vec2d size = this.getSize(task, context);
        this.getBackground().blit(((RendererContext)context).getMatrices(), -1, -1, 0, (int)size.getX() + 2, (int)size.getY() + 2);
        UIHelper.renderOverflowHidden(((RendererContext)context).getMatrices(), matrices -> this.onRenderBackground(task, context), matrices -> {
            context.push();
            context.translate(this.getTranslation(task, context).getX(), this.getTranslation(task, context).getY(), 0.0);
            this.onRenderForeground(task, context);
            context.pop();
        });
    }

    public boolean isInBounds(Vec2d mouse, T task, C context) {
        Vec2d size = this.getSize(task, context);
        return mouse.getX() >= 0.0 && mouse.getX() < size.getX() && mouse.getY() >= 0.0 && mouse.getY() <= size.getY();
    }

    @Override
    public boolean onMouseClicked(T task, int button, C context) {
        if (!this.isInBounds(((RendererContext)context).getMouse(), task, context)) {
            return false;
        }
        this.clickedPos = ((RendererContext)context).getMouse();
        ((RendererContext)context).pushMouse(((RendererContext)context).getMouse().subtract(this.getTranslation(task, context)));
        this.dragging = true;
        for (Task child : ((Task)task).getChildren()) {
            if (!child.onMouseClicked(button, (RendererContext)context)) continue;
            this.dragging = false;
            break;
        }
        ((RendererContext)context).popMouse();
        return true;
    }

    @Override
    public boolean onMouseReleased(T task, int button, C context) {
        this.dragging = false;
        ((RendererContext)context).pushMouse(((RendererContext)context).getMouse().subtract(this.getTranslation(task, context)));
        for (Task child : ((Task)task).getChildren()) {
            child.onMouseReleased(button, (RendererContext)context);
        }
        ((RendererContext)context).popMouse();
        return button == 0;
    }

    @Override
    public boolean onMouseDragged(T task, int button, double dragX, double dragY, C context) {
        ((RendererContext)context).pushMouse(((RendererContext)context).getMouse().subtract(this.getTranslation(task, context)));
        for (Task child : ((Task)task).getChildren()) {
            if (!child.onMouseDragged(button, dragX, dragY, (RendererContext)context)) continue;
            ((RendererContext)context).popMouse();
            return true;
        }
        ((RendererContext)context).popMouse();
        if (!this.dragging) {
            return false;
        }
        Vec2d clicked = ((RendererContext)context).getMouse();
        if (this.clickedPos != null) {
            Vec2d delta = clicked.subtract(this.clickedPos);
            if (this.getScrollType(task, context) == ScrollType.VERTICAL) {
                double value = delta.getY();
                Vec2d translation = this.getTranslation(task, context);
                if (translation.getY() + value > 0.0) {
                    value = 0.0;
                }
                this.addTranslation(task, context, new Vec2d(0.0, value));
            } else if (this.getScrollType(task, context) == ScrollType.HORIZONTAL) {
                this.addTranslation(task, context, new Vec2d(delta.getX(), 0.0));
            } else {
                this.addTranslation(task, context, delta);
            }
        }
        this.clickedPos = clicked;
        return true;
    }

    @Override
    public boolean onMouseScrolled(T task, double delta, C context) {
        double value = delta * 12.0;
        if (this.getScrollType(task, context) == ScrollType.HORIZONTAL) {
            this.addTranslation(task, context, new Vec2d(value, 0.0));
        } else if (this.getScrollType(task, context) == ScrollType.VERTICAL) {
            Vec2d translation = this.getTranslation(task, context);
            if (translation.getY() + value > 0.0) {
                value = translation.getY() * -1.0;
            }
            this.addTranslation(task, context, new Vec2d(0.0, value));
        }
        return super.onMouseScrolled(task, delta, context);
    }

    @Override
    public boolean isMouseOver(T task, C context) {
        if (this.dragging) {
            return true;
        }
        Vec2d size = this.getSize(task, context);
        Vec2d mouse = ((RendererContext)context).getMouse();
        return mouse.getX() >= 0.0 && mouse.getX() < size.getX() && mouse.getY() >= 0.0 && mouse.getY() <= size.getY();
    }

    @Override
    public void writeBits(BitBuffer buffer) {
        super.writeBits(buffer);
        Adapters.BOOLEAN.writeBits(this.dragging, buffer);
        Adapters.VEC_2D.asNullable().writeBits(this.clickedPos, buffer);
    }

    @Override
    public void readBits(BitBuffer buffer) {
        super.readBits(buffer);
        this.dragging = Adapters.BOOLEAN.readBits(buffer).orElseThrow();
        this.clickedPos = Adapters.VEC_2D.asNullable().readBits(buffer).orElse(new Vec2d());
    }

    @Override
    public Optional<CompoundTag> writeNbt() {
        return super.writeNbt().map(nbt -> {
            Adapters.BOOLEAN.writeNbt(this.dragging).ifPresent(value -> nbt.m_128365_("dragging", value));
            Adapters.VEC_2D.writeNbt(this.clickedPos).ifPresent(value -> nbt.m_128365_("clickedPos", value));
            return nbt;
        });
    }

    @Override
    public void readNbt(CompoundTag nbt) {
        super.readNbt(nbt);
        this.dragging = Adapters.BOOLEAN.readNbt(nbt.m_128423_("dragging")).orElse(false);
        this.clickedPos = Adapters.VEC_2D.readNbt(nbt.m_128423_("clickedPos")).orElse(null);
    }

    @Override
    public Optional<JsonObject> writeJson() {
        return super.writeJson().map(json -> {
            Adapters.BOOLEAN.writeJson(this.dragging).ifPresent(value -> json.add("dragging", value));
            Adapters.VEC_2D.writeJson(this.clickedPos).ifPresent(value -> json.add("clickedPos", value));
            return json;
        });
    }

    @Override
    public void readJson(JsonObject json) {
        super.readJson(json);
        this.dragging = Adapters.BOOLEAN.readJson(json.get("dragging")).orElse(false);
        this.clickedPos = Adapters.VEC_2D.readJson(json.get("clickedPos")).orElse(null);
    }

    public static enum ScrollType {
        ZOOM,
        VERTICAL,
        HORIZONTAL;

    }
}

