/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.task.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import iskallia.vault.task.Task;
import iskallia.vault.task.renderer.Vec2d;
import iskallia.vault.task.renderer.context.RendererContext;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public class TaskWidget
implements Widget,
GuiEventListener,
NarratableEntry {
    private Vec2d offset;
    private Task task;
    private Supplier<RendererContext> context;

    public TaskWidget(Vec2d offset, Task task, Supplier<RendererContext> context) {
        this.offset = offset;
        this.task = task;
        this.context = context;
    }

    private RendererContext getContext(Consumer<RendererContext> configurator) {
        RendererContext context = this.context.get();
        configurator.accept(context);
        return context;
    }

    private RendererContext getContext() {
        return this.getContext(context -> {});
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float tickDelta) {
        matrices.m_85836_();
        matrices.m_85837_(this.offset.getX(), this.offset.getY(), 0.0);
        this.task.onRender(this.getContext(context -> {
            context.setMatrices(matrices);
            context.setTickDelta(tickDelta);
            context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset));
        }));
        matrices.m_85849_();
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.task.onMouseMoved(this.getContext(context -> context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset))));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.task.onMouseClicked(button, this.getContext(context -> context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset))));
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.task.onMouseReleased(button, this.getContext(context -> context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset))));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.task.onMouseDragged(button, dragX, dragY, this.getContext(context -> context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset))));
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.task.onMouseScrolled(delta, this.getContext(context -> context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset))));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.task.onKeyPressed(keyCode, scanCode, modifiers, this.getContext());
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.task.onKeyReleased(keyCode, scanCode, modifiers, this.getContext());
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.task.onCharTyped(codePoint, modifiers, this.getContext());
    }

    public boolean m_5755_(boolean focus) {
        return this.task.onChangeFocus(focus, this.getContext());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.task.isMouseOver(this.getContext(context -> context.setMouse(new Vec2d(mouseX, mouseY).subtract(this.offset))));
    }

    public void m_142291_(NarrationElementOutput output) {
        this.task.onUpdateNarration(output, this.getContext());
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.task.getNarrationPriority(this.getContext());
    }

    public boolean m_142518_() {
        return this.task.isActive(this.getContext());
    }
}

